/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;

public class RenderTileAltar
extends TileEntitySpecialRenderer<TileAltar> {
    public void render(@Nonnull TileAltar altar, double d0, double d1, double d2, float pticks, int digProgress, float unused) {
        if (!altar.func_145831_w().func_175668_a(altar.func_174877_v(), false) || altar.func_145831_w().func_180495_p(altar.func_174877_v()).func_177230_c() != ModBlocks.altar) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(d0 + 0.5), (double)(d1 + 1.5), (double)(d2 + 0.5));
        GlStateManager.func_179091_B();
        boolean water = altar.hasWater();
        boolean lava = altar.hasLava();
        if (water || lava) {
            GlStateManager.func_179094_E();
            float s = 0.0390625f;
            float v = 0.125f;
            float w = -v * 2.5f;
            if (water) {
                int petals = 0;
                for (int i = 0; i < altar.getSizeInventory() && !altar.getItemHandler().getStackInSlot(i).func_190926_b(); ++i) {
                    ++petals;
                }
                if (petals > 0) {
                    float modifier = 6.0f;
                    float rotationModifier = 0.25f;
                    float radiusBase = 1.2f;
                    float radiusMod = 0.1f;
                    double ticks = (double)((float)ClientTickHandler.ticksInGame + pticks) * 0.5;
                    float offsetPerPetal = 360 / petals;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)-0.05f, (float)-0.5f, (float)0.0f);
                    GlStateManager.func_179152_a((float)v, (float)v, (float)v);
                    for (int i = 0; i < petals; ++i) {
                        float offset = offsetPerPetal * (float)i;
                        float deg = (int)(ticks / 0.25 % 360.0 + (double)offset);
                        float rad = deg * (float)Math.PI / 180.0f;
                        float radiusX = (float)((double)1.2f + (double)0.1f * Math.sin(ticks / 6.0));
                        float radiusZ = (float)((double)1.2f + (double)0.1f * Math.cos(ticks / 6.0));
                        float x = (float)((double)radiusX * Math.cos(rad));
                        float z = (float)((double)radiusZ * Math.sin(rad));
                        float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
                        float xRotate = (float)Math.sin(ticks * 0.25) / 2.0f;
                        float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                        float zRotate = (float)Math.cos(ticks * 0.25) / 2.0f;
                        GlStateManager.func_179109_b((float)(v /= 2.0f), (float)v, (float)v);
                        GlStateManager.func_179114_b((float)deg, (float)xRotate, (float)yRotate, (float)zRotate);
                        GlStateManager.func_179109_b((float)(-v), (float)(-v), (float)(-v));
                        v *= 2.0f;
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        ItemStack stack = altar.getItemHandler().getStackInSlot(i);
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179121_F();
                }
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Fluid fluid = lava ? FluidRegistry.LAVA : FluidRegistry.WATER;
            int brightness = lava ? 240 : -1;
            float alpha = lava ? 1.0f : 0.7f;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179118_c();
            if (lava) {
                GlStateManager.func_179140_f();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179109_b((float)w, (float)-0.3f, (float)w);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            this.renderIcon(0, 0, fluid.getStill(), 16, 16, brightness);
            if (lava) {
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    public void renderIcon(int par1, int par2, ResourceLocation loc, int par4, int par5, int brightness) {
        TextureAtlasSprite par3Icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString());
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }
}

