/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.network.PacketDodge;
import vazkii.botania.common.network.PacketHandler;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="botania")
public class ItemDodgeRing
extends ItemBauble {
    public static final String TAG_DODGE_COOLDOWN = "dodgeCooldown";
    public static final int MAX_CD = 20;
    private static boolean oldLeftDown;
    private static boolean oldRightDown;
    private static int leftDown;
    private static int rightDown;

    public ItemDodgeRing() {
        super("dodgeRing");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onKeyDown(InputEvent.KeyInputEvent event) {
        int oldRight;
        Minecraft mc = Minecraft.func_71410_x();
        IBaublesItemHandler baublesInv = BaublesApi.getBaublesHandler((EntityPlayer)mc.field_71439_g);
        int slot = BaublesApi.isBaubleEquipped((EntityPlayer)mc.field_71439_g, (Item)ModItems.dodgeRing);
        if (slot < 0) {
            return;
        }
        ItemStack ringStack = baublesInv.getStackInSlot(slot);
        if (ItemNBTHelper.getInt(ringStack, TAG_DODGE_COOLDOWN, 0) > 0) {
            return;
        }
        int threshold = 4;
        if (mc.field_71474_y.field_74370_x.func_151470_d() && !oldLeftDown) {
            leftDown = ClientTickHandler.ticksInGame;
            int oldLeft = leftDown;
            if (leftDown - oldLeft < threshold) {
                ItemDodgeRing.dodge((EntityPlayer)mc.field_71439_g, true);
            }
        } else if (mc.field_71474_y.field_74366_z.func_151470_d() && !oldRightDown && (rightDown = ClientTickHandler.ticksInGame) - (oldRight = rightDown) < threshold) {
            ItemDodgeRing.dodge((EntityPlayer)mc.field_71439_g, false);
        }
        oldLeftDown = mc.field_71474_y.field_74370_x.func_151470_d();
        oldRightDown = mc.field_71474_y.field_74366_z.func_151470_d();
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
        if (cd > 0) {
            ItemNBTHelper.setInt(stack, TAG_DODGE_COOLDOWN, cd - 1);
        }
    }

    private static void dodge(EntityPlayer player, boolean left) {
        if (player.field_71075_bZ.field_75100_b || !player.field_70122_E || (double)player.field_191988_bg > 0.2 || (double)player.field_191988_bg < -0.2) {
            return;
        }
        float yaw = player.field_70177_z;
        float x = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float z = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        Vector3 lookVec = new Vector3(x, 0.0, z);
        Vector3 sideVec = lookVec.crossProduct(new Vector3(0.0, left ? 1.0 : -1.0, 0.0)).multiply(1.25);
        player.field_70159_w = sideVec.x;
        player.field_70181_x = sideVec.y;
        player.field_70179_y = sideVec.z;
        PacketHandler.sendToServer(new PacketDodge());
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(ScaledResolution resolution, EntityPlayer player, ItemStack stack, float pticks) {
        int xo = resolution.func_78326_a() / 2 - 20;
        int y = resolution.func_78328_b() / 2 + 20;
        if (!player.field_71075_bZ.field_75100_b) {
            int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
            int width = Math.min((int)(((float)cd - pticks) * 2.0f), 40);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (width > 0) {
                Gui.func_73734_a((int)xo, (int)(y - 2), (int)(xo + 40), (int)(y - 1), (int)-2013265920);
                Gui.func_73734_a((int)xo, (int)(y - 2), (int)(xo + width), (int)(y - 1), (int)-1);
            }
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }
}

