/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.CustomStateMapper;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.block.INoCullBlock;
import epicsquid.mysticallib.model.CustomModelBlock;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLeavesBase
extends BlockLeaves
implements IBlock,
IModeledObject,
ICustomModeledObject,
INoCullBlock {
    @Nonnull
    private Item itemBlock;
    private List<ItemStack> drops;
    private boolean hasCustomModel = false;
    private boolean hasItems = true;
    private boolean noCull = true;
    private boolean isFlammable = false;
    private Supplier<ItemStack> sapling = null;
    private AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private BlockRenderLayer layer = BlockRenderLayer.CUTOUT_MIPPED;
    private int saplingChance;
    @Nonnull
    public String name;

    public BlockLeavesBase(float hardness, @Nonnull String name, Supplier<ItemStack> sapling, int saplingChance) {
        this.name = name;
        this.sapling = sapling;
        this.saplingChance = saplingChance;
        this.func_149663_c(name);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
        this.func_149711_c(hardness);
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(LibRegistry.getActiveModid(), name);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    @Nonnull
    public BlockLeavesBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockLeavesBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Nonnull
    public BlockLeavesBase setDrops(@Nonnull List<ItemStack> drops) {
        this.drops = drops;
        return this;
    }

    protected int func_176232_d(IBlockState state) {
        return this.saplingChance;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack sap;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.func_176232_d(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0 && this.sapling != null && !(sap = this.sapling.get()).func_190926_b()) {
            drops.add((Object)sap);
        }
    }

    @Nonnull
    public BlockLeavesBase setBox(@Nonnull AxisAlignedBB box) {
        this.box = box;
        return this;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return this.box;
    }

    @Nonnull
    public BlockLeavesBase setNoCull(boolean noCull) {
        this.noCull = noCull;
        return this;
    }

    @Override
    public boolean noCull() {
        return this.noCull;
    }

    @Nonnull
    public BlockLeavesBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockLeavesBase setHarvestReqs(@Nonnull String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @Nonnull
    public BlockLeavesBase setHasItem(boolean hasItem) {
        this.hasItems = hasItem;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockLeavesBase setLayer(@Nonnull BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{field_176236_b}).func_178442_a(new IProperty[]{field_176237_a}).func_178441_a());
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.getRegistryName().func_110624_b() + ":blocks/" + this.getRegistryName().func_110623_a());
            if (this.getParentState() != null) {
                defaultTex = new ResourceLocation(this.getParentState().func_177230_c().getRegistryName().func_110624_b() + ":blocks/" + this.getParentState().func_177230_c().getRegistryName().func_110623_a());
            }
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#handlers"), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
        }
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.hasItems) {
            super.func_149666_a(tab, items);
        }
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Override
    public ItemBlock setItemBlock(ItemBlock block) {
        this.itemBlock = block;
        return block;
    }

    @Nullable
    protected IBlockState getParentState() {
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.drops != null && this.drops.size() > 0) {
            return this.drops.get(0).func_77973_b();
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return this.getModelClass(0);
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass(int type) {
        return BakedModelBlock.class;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }
}

