/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.feature;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.base.ChainHandler;
import vazkii.quark.world.client.render.ChainRenderer;
import vazkii.quark.world.item.ItemChain;

public class ChainLinkage
extends Feature {
    public static boolean craftsArmor;
    public static Item chain;
    private static final TIntObjectMap<UUID> AWAIT_MAP;

    @Override
    public void setupConfig() {
        craftsArmor = this.loadPropBool("Crafts Armor", "Can vehicle-linking chains be used for crafting chain armor?", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        chain = new ItemChain();
        RecipeHandler.addShapedRecipe((ItemStack)ProxyRegistry.newStack((Item)chain, (int)3), (Object[])new Object[]{"NN ", "NI ", "  I", Character.valueOf('N'), "nuggetIron", Character.valueOf('I'), "ingotIron"});
        if (craftsArmor) {
            RecipeHandler.addShapedRecipe((ItemStack)ProxyRegistry.newStack((Item)Items.field_151020_U), (Object[])new Object[]{"CCC", "C C", Character.valueOf('C'), ProxyRegistry.newStack((Item)chain)});
            RecipeHandler.addShapedRecipe((ItemStack)ProxyRegistry.newStack((Item)Items.field_151023_V), (Object[])new Object[]{"C C", "CCC", "CCC", Character.valueOf('C'), ProxyRegistry.newStack((Item)chain)});
            RecipeHandler.addShapedRecipe((ItemStack)ProxyRegistry.newStack((Item)Items.field_151022_W), (Object[])new Object[]{"CCC", "C C", "C C", Character.valueOf('C'), ProxyRegistry.newStack((Item)chain)});
            RecipeHandler.addShapedRecipe((ItemStack)ProxyRegistry.newStack((Item)Items.field_151029_X), (Object[])new Object[]{"C C", "C C", Character.valueOf('C'), ProxyRegistry.newStack((Item)chain)});
        }
    }

    public static void queueChainUpdate(int vehicle, UUID other) {
        if (other != null) {
            AWAIT_MAP.put(vehicle, (Object)other);
        }
    }

    public static void onEntityUpdate(Entity vehicle) {
        if (ChainHandler.canBeLinkedTo(vehicle)) {
            ChainHandler.adjustVehicle(vehicle);
        }
    }

    public static void drop(Entity vehicle) {
        if (ChainHandler.getLinked(vehicle) != null) {
            vehicle.func_70099_a(new ItemStack(chain), 0.0f);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        Entity link = ChainHandler.getLinked(entity);
        boolean sneaking = player.func_70093_af();
        ArrayList<Entity> linkedToPlayer = new ArrayList<Entity>();
        for (Entity linkCandidate : entity.field_70170_p.func_72872_a(Entity.class, player.func_174813_aQ().func_186662_g(8.0))) {
            if (ChainHandler.getLinked(linkCandidate) != player) continue;
            linkedToPlayer.add(linkCandidate);
        }
        if (ChainHandler.canBeLinked(entity) && linkedToPlayer.isEmpty() && !stack.func_190926_b() && stack.func_77973_b() == chain && link == null) {
            if (!entity.field_70170_p.field_72995_K) {
                ChainHandler.setLink(entity, player.func_110124_au(), true);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        } else if (link == player) {
            if (!entity.field_70170_p.field_72995_K) {
                if (!player.func_184812_l_()) {
                    entity.func_70099_a(new ItemStack(chain), 0.0f);
                }
                ChainHandler.setLink(entity, null, true);
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        } else if (ChainHandler.canBeLinked(entity) && !linkedToPlayer.isEmpty()) {
            if (!entity.field_70170_p.field_72995_K) {
                for (Entity linked : linkedToPlayer) {
                    ChainHandler.setLink(linked, entity.func_110124_au(), true);
                }
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        } else if (link != null && sneaking) {
            if (!entity.field_70170_p.field_72995_K) {
                if (!player.func_184812_l_()) {
                    entity.func_70099_a(new ItemStack(chain), 0.0f);
                }
                ChainHandler.setLink(entity, null, true);
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientUpdateTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            ChainRenderer.updateTick();
        }
    }

    @SubscribeEvent
    public void onVehicleSeen(PlayerEvent.StartTracking event) {
        if (ChainHandler.canBeLinked(event.getTarget())) {
            ChainHandler.updateLinkState(event.getTarget(), ChainHandler.getLink(event.getTarget()), event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onVehicleArrive(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (event.getWorld().field_72995_K && ChainHandler.canBeLinked(target)) {
            int id = target.func_145782_y();
            if (AWAIT_MAP.containsKey(id)) {
                target.getEntityData().func_186854_a("Quark:VehicleLink", (UUID)AWAIT_MAP.get(id));
            }
            AWAIT_MAP.remove(id);
        }
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        ChainLinkage.onEntityUpdate((Entity)event.getMinecart());
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        AWAIT_MAP = new TIntObjectHashMap();
    }
}

