/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import vazkii.quark.experimental.block.FramedBlockCommons;

public class FramedBlockModel
extends BakedModelWrapper<IBakedModel> {
    public static final Map<String, RetextureData> cache = new HashMap<String, RetextureData>();
    private final IModel model;

    public FramedBlockModel(IBakedModel originalModel, IModel model) {
        super(originalModel);
        this.model = model;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IBakedModel bakedModel = this.originalModel;
        if (state instanceof IExtendedBlockState) {
            RetextureData data;
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            IBlockState texState = (IBlockState)extendedState.getValue((IUnlistedProperty)FramedBlockCommons.STATE);
            String cacheId = (texState == null ? "null" : texState.toString()) + "_" + state.toString() + "_" + (side == null ? "null" : side.toString()) + (MinecraftForgeClient.getRenderLayer() == null ? "null" : MinecraftForgeClient.getRenderLayer().toString());
            if (!cache.containsKey(cacheId)) {
                TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{this.func_177554_e()};
                int[] tintIndices = new int[]{0};
                if (texState != null && texState.func_177230_c() != Blocks.field_150350_a) {
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(texState);
                    sprites[0] = model.func_177554_e();
                    List texQuads = model.func_188616_a(texState, side, rand);
                    if (texQuads.size() > 0) {
                        sprites = new TextureAtlasSprite[texQuads.size()];
                        tintIndices = new int[texQuads.size()];
                        for (int i = 0; i < texQuads.size(); ++i) {
                            tintIndices[i] = ((BakedQuad)texQuads.get(i)).func_178212_b() ? ((BakedQuad)texQuads.get(i)).func_178211_c() : -1;
                            sprites[i] = ((BakedQuad)texQuads.get(i)).func_187508_a();
                        }
                    }
                }
                data = new RetextureData(sprites, tintIndices);
                cache.put(cacheId, data);
            } else {
                data = cache.get(cacheId);
            }
            if (data != null) {
                IModel retextured = data.retextureModel(this.model);
                bakedModel = retextured.bake(retextured.getDefaultState(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
            }
        }
        return bakedModel.func_188616_a(state, side, rand);
    }

    private static class RetextureData {
        private static final String[] SIDES = new String[]{"down", "up", "north", "south", "west", "east"};
        private final TextureAtlasSprite[] sprites;
        private final int[] tintIndices;

        public RetextureData(TextureAtlasSprite[] sprites, int[] tintIndices) {
            this.sprites = sprites;
            this.tintIndices = tintIndices;
        }

        private TextureAtlasSprite getSprite(int side) {
            return this.sprites[Math.min(this.sprites.length - 1, side)];
        }

        private int getTint(int side) {
            return this.tintIndices[Math.min(this.tintIndices.length - 1, side)];
        }

        private IModel retextureModel(IModel model) {
            HashMap<String, String> retextureMap = new HashMap<String, String>();
            for (int i = 0; i < SIDES.length; ++i) {
                retextureMap.put(SIDES[i], this.getSprite(i).func_94215_i());
            }
            return model.retexture(ImmutableMap.copyOf(retextureMap));
        }
    }

    private static class FramedBlockColor
    implements IBlockColor {
        private FramedBlockColor() {
        }

        public int func_186720_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState extendedState = (IExtendedBlockState)state;
                IBlockState iBlockState = (IBlockState)extendedState.getValue((IUnlistedProperty)FramedBlockCommons.STATE);
            }
            return 0;
        }
    }
}

