/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.handler.RayTraceHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.feature.LockDirectionHotkey;

public class ReacharoundPlacing
extends Feature {
    float leniency;
    List<String> whitelist;

    @Override
    public void setupConfig() {
        this.leniency = (float)this.loadPropDouble("Leniency", "How lenient the detection for reacharound should be. Higher leniency means you can look further away from the block edge", 0.5);
        String[] whitelistArr = this.loadPropStringList("Whitelist", "A whitelist of items that are allowed to reacharound (all blocks can without being here)", new String[]{"quark:trowel"});
        this.whitelist = Arrays.asList(whitelistArr);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderGameOverlayEvent.Post event) {
        BlockPos pos;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && (pos = this.getPlayerReacharoundTarget((EntityPlayer)player)) != null) {
            ScaledResolution res = event.getResolution();
            String s = "[  ]";
            mc.field_71466_p.func_78276_b(s, res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(s) / 2 + 1, res.func_78328_b() / 2 - 3, 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = this.getPlayerReacharoundTarget(player);
        if (pos != null) {
            int count = stack.func_190916_E();
            EnumHand hand = event.getHand();
            IBlockState currState = player.field_70170_p.func_180495_p(pos);
            EnumActionResult res = stack.func_77973_b().func_180614_a(player, player.func_130014_f_(), pos, hand, EnumFacing.DOWN, 0.5f, 1.0f, 0.5f);
            if (res != EnumActionResult.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(res);
                if (res == EnumActionResult.SUCCESS) {
                    if (!player.field_70170_p.func_180495_p(pos).equals(currState)) {
                        LockDirectionHotkey.fixBlockRotation(player.field_70170_p, player, pos);
                    }
                    player.func_184609_a(hand);
                }
                if (player.func_184812_l_() && stack.func_190916_E() < count) {
                    stack.func_190920_e(count);
                }
            }
        }
    }

    private BlockPos getPlayerReacharoundTarget(EntityPlayer player) {
        float leniency;
        RayTraceResult take2Res;
        Vec3d ray;
        if (player.field_70125_A < 0.0f || !this.validateReacharoundStack(player.func_184614_ca()) && !this.validateReacharoundStack(player.func_184592_cb())) {
            return null;
        }
        World world = player.field_70170_p;
        Pair<Vec3d, Vec3d> params = RayTraceHandler.getEntityParams((Entity)player);
        double range = RayTraceHandler.getEntityRange((EntityLivingBase)player);
        Vec3d rayPos = (Vec3d)params.getLeft();
        RayTraceResult normalRes = RayTraceHandler.rayTrace(world, rayPos, ray = ((Vec3d)params.getRight()).func_186678_a(range), false);
        if ((normalRes == null || normalRes.field_72313_a == RayTraceResult.Type.MISS) && (take2Res = RayTraceHandler.rayTrace(world, rayPos = rayPos.func_72441_c(0.0, (double)(leniency = 0.5f), 0.0), ray, false)) != null && take2Res.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = take2Res.func_178782_a().func_177977_b();
            IBlockState state = world.func_180495_p(pos);
            if (player.field_70163_u - (double)pos.func_177956_o() > 1.0 && (world.func_175623_d(pos) || state.func_177230_c().func_176200_f((IBlockAccess)world, pos))) {
                return pos;
            }
        }
        return null;
    }

    private boolean validateReacharoundStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemBlock || this.whitelist.contains(Objects.toString(item.getRegistryName()).toString());
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

