/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook;

import com.ferreusveritas.warpbook.Crafting;
import com.ferreusveritas.warpbook.Proxy;
import com.ferreusveritas.warpbook.WarpBlocks;
import com.ferreusveritas.warpbook.WarpItems;
import com.ferreusveritas.warpbook.WarpWorldStorage;
import com.ferreusveritas.warpbook.commands.CreateWaypointCommand;
import com.ferreusveritas.warpbook.commands.DeleteWaypointCommand;
import com.ferreusveritas.warpbook.commands.GiveWarpCommand;
import com.ferreusveritas.warpbook.commands.ListWaypointCommand;
import com.ferreusveritas.warpbook.core.WarpDrive;
import com.ferreusveritas.warpbook.event.WarpEventHandler;
import com.ferreusveritas.warpbook.gui.GuiManager;
import com.ferreusveritas.warpbook.item.WarpBookItem;
import com.ferreusveritas.warpbook.net.packet.PacketEffect;
import com.ferreusveritas.warpbook.net.packet.PacketSyncWaypoints;
import com.ferreusveritas.warpbook.net.packet.PacketWarp;
import com.ferreusveritas.warpbook.net.packet.PacketWaypointName;
import com.ferreusveritas.warpbook.util.WarpUtils;
import com.ferreusveritas.warpbook.util.Waypoint;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="warpbook", name="Warp Book", version="@VERSION@", acceptedMinecraftVersions="[1.12.2]")
public class WarpBookMod {
    @Mod.Instance(value="warpbook")
    public static WarpBookMod instance;
    public static final Logger logger;
    public static final SimpleNetworkWrapper network;
    @SidedProxy(clientSide="com.ferreusveritas.warpbook.client.ClientProxy", serverSide="com.ferreusveritas.warpbook.Proxy")
    public static Proxy proxy;
    public static WarpDrive warpDrive;
    public static WarpItems items;
    public static WarpBlocks blocks;
    public static Crafting crafting;
    private static int guiIndex;
    public static float exhaustionCoefficient;
    public static boolean deathPagesEnabled;
    public static Integer[] disabledDestinations;
    public static Integer[] disabledLeaving;
    public static final int WarpBookWarpGuiIndex;
    public static final int WarpBookWaypointGuiIndex;
    public static final int WarpBookInventoryGuiIndex;
    public static final int BookClonerInventoryGuiIndex;
    public static HashMap<EntityPlayer, ItemStack> lastHeldBooks;
    public static HashMap<EntityPlayer, ItemStack> formingPages;
    private static Configuration config;
    public static CreativeTabs tabBook;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int i;
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        exhaustionCoefficient = (float)config.get("tweaks", "exhaustion_coefficient", 0.0).getDouble(10.0);
        deathPagesEnabled = config.get("features", "death_pages", true).getBoolean(true);
        int[] disabledDestinationsP = config.get("features", "disabled_destination_dimensions", new int[0]).getIntList();
        int[] disabledLeavingP = config.get("features", "disabled_departing_dimensions", new int[0]).getIntList();
        disabledDestinations = new Integer[disabledDestinationsP.length];
        disabledLeaving = new Integer[disabledLeavingP.length];
        for (i = 0; i < disabledDestinationsP.length; ++i) {
            WarpBookMod.disabledDestinations[i] = disabledDestinationsP[i];
        }
        for (i = 0; i < disabledLeavingP.length; ++i) {
            WarpBookMod.disabledLeaving[i] = disabledLeavingP[i];
        }
        items = new WarpItems();
        blocks = new WarpBlocks();
        crafting = new Crafting();
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)WarpEventHandler.EVENT_HANDLER);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiManager());
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        int disc = 0;
        network.registerMessage(PacketWarp.class, PacketWarp.class, disc++, Side.SERVER);
        network.registerMessage(PacketWaypointName.class, PacketWaypointName.class, disc++, Side.SERVER);
        network.registerMessage(PacketSyncWaypoints.class, PacketSyncWaypoints.class, disc++, Side.CLIENT);
        network.registerMessage(PacketEffect.class, PacketEffect.class, disc++, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ServerCommandManager manager = (ServerCommandManager)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        manager.func_71560_a((ICommand)new CreateWaypointCommand());
        manager.func_71560_a((ICommand)new ListWaypointCommand());
        manager.func_71560_a((ICommand)new DeleteWaypointCommand());
        manager.func_71560_a((ICommand)new GiveWarpCommand());
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (deathPagesEnabled && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getSource() != DamageSource.field_76380_i && player.func_110143_aJ() <= event.getAmount()) {
                for (ItemStack item : player.field_71071_by.field_70462_a) {
                    if (item == null || !(item.func_77973_b() instanceof WarpBookItem) || WarpBookItem.getRespawnsLeft(item) <= 0) continue;
                    WarpBookItem.decrRespawnsLeft(item);
                    WarpWorldStorage s = WarpWorldStorage.get(player.field_70170_p);
                    s.setLastDeath(player.func_146103_bH().getId(), player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_71093_bK);
                    s.save(player.field_70170_p);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        WarpWorldStorage s;
        Waypoint death;
        if (deathPagesEnabled && (death = (s = WarpWorldStorage.get(event.player.field_70170_p)).getLastDeath(event.player.func_146103_bH().getId())) != null) {
            s.clearLastDeath(event.player.func_146103_bH().getId());
            ItemStack page = new ItemStack((Item)WarpBookMod.items.locusWarpPageItem, 1);
            WarpUtils.Bind(page, death.x, death.y, death.z, death.dim);
            event.player.field_70170_p.func_72838_d((Entity)new EntityItem(event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v, page));
            s.save(event.player.field_70170_p);
        }
    }

    static {
        logger = LogManager.getLogger((String)"warpbook");
        network = NetworkRegistry.INSTANCE.newSimpleChannel("warpbook");
        warpDrive = new WarpDrive();
        guiIndex = 42;
        deathPagesEnabled = true;
        WarpBookWarpGuiIndex = guiIndex++;
        WarpBookWaypointGuiIndex = guiIndex++;
        WarpBookInventoryGuiIndex = guiIndex++;
        BookClonerInventoryGuiIndex = guiIndex++;
        lastHeldBooks = new HashMap();
        formingPages = new HashMap();
        tabBook = new CreativeTabs("tabWarpBook"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((Item)WarpBookMod.items.warpBookItem);
            }
        };
    }

    @Mod.EventBusSubscriber(modid="warpbook")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            blocks.register((IForgeRegistry<Block>)registry);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            items.register((IForgeRegistry<Item>)registry);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            IForgeRegistry registry = event.getRegistry();
            crafting.register((IForgeRegistry<IRecipe>)registry);
        }
    }
}

