/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook;

import com.ferreusveritas.warpbook.net.packet.PacketSyncWaypoints;
import com.ferreusveritas.warpbook.util.MathUtils;
import com.ferreusveritas.warpbook.util.Waypoint;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;

public class WarpWorldStorage
extends WorldSavedData {
    public HashMap<String, Waypoint> table;
    public HashMap<UUID, Waypoint> deaths;
    private static final String IDENTIFIER = "WarpBook";

    public WarpWorldStorage(String identifier) {
        super(identifier);
        if (this.table == null) {
            this.table = new HashMap();
        }
        if (this.deaths == null) {
            this.deaths = new HashMap();
        }
    }

    public static WarpWorldStorage get(World world) {
        if (world.func_175693_T().func_75742_a(WarpWorldStorage.class, IDENTIFIER) == null) {
            world.func_175693_T().func_75745_a(IDENTIFIER, (WorldSavedData)new WarpWorldStorage(IDENTIFIER));
        }
        WarpWorldStorage storage = (WarpWorldStorage)world.func_175693_T().func_75742_a(WarpWorldStorage.class, IDENTIFIER);
        return storage;
    }

    public void save(World world) {
        this.func_76185_a();
        world.func_175693_T().func_75745_a(IDENTIFIER, (WorldSavedData)this);
    }

    public void func_76184_a(NBTTagCompound var1) {
        NBTTagList waypoints = var1.func_150295_c("waypoints", 10);
        for (int i = 0; i < waypoints.func_74745_c(); ++i) {
            NBTTagCompound waypoint = waypoints.func_150305_b(i);
            this.table.put(waypoint.func_74779_i("name"), new Waypoint(waypoint.func_74775_l("data")));
        }
        NBTTagList deathsNBT = var1.func_150295_c("deaths", 10);
        for (int i = 0; i < deathsNBT.func_74745_c(); ++i) {
            NBTTagCompound death = deathsNBT.func_150305_b(i);
            this.deaths.put(UUID.fromString(death.func_74779_i("uuid")), new Waypoint(death.func_74775_l("data")));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound var1) {
        NBTTagList waypoints = new NBTTagList();
        for (Map.Entry<String, Waypoint> waypointSource : this.table.entrySet()) {
            NBTTagCompound waypoint = new NBTTagCompound();
            waypoint.func_74778_a("name", waypointSource.getKey());
            NBTTagCompound data = new NBTTagCompound();
            waypointSource.getValue().writeToNBT(data);
            waypoint.func_74782_a("data", (NBTBase)data);
            waypoints.func_74742_a((NBTBase)waypoint);
        }
        NBTTagList deathsNBT = new NBTTagList();
        for (Map.Entry<UUID, Waypoint> deathSource : this.deaths.entrySet()) {
            NBTTagCompound death = new NBTTagCompound();
            death.func_74778_a("uuid", deathSource.getKey().toString());
            NBTTagCompound data = new NBTTagCompound();
            deathSource.getValue().writeToNBT(data);
            death.func_74782_a("data", (NBTBase)data);
            deathsNBT.func_74742_a((NBTBase)death);
        }
        var1.func_74782_a("waypoints", (NBTBase)waypoints);
        var1.func_74782_a("deaths", (NBTBase)deathsNBT);
        return var1;
    }

    void updateClient(EntityPlayerMP player, FMLNetworkEvent.ServerConnectionFromClientEvent e) {
        FMLEmbeddedChannel channel = NetworkRegistry.INSTANCE.getChannel("warpbook", Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)NetworkDispatcher.get((NetworkManager)e.getManager()));
        channel.writeAndFlush((Object)new PacketSyncWaypoints(this.table)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public boolean waypointExists(String name) {
        return this.table.containsKey(name);
    }

    public Waypoint getWaypoint(String name) {
        return this.table.get(name);
    }

    public void addWaypoint(Waypoint point) {
        this.table.put(point.name, point);
        this.func_76185_a();
    }

    public Set<String> listWaypoints() {
        return this.table.keySet();
    }

    public boolean deleteWaypoint(String waypoint) {
        boolean res = this.table.remove(waypoint) != null;
        this.func_76185_a();
        return res;
    }

    public void setLastDeath(UUID id, double posX, double posY, double posZ, int dim) {
        this.deaths.put(id, new Waypoint("Death Point", "death", MathUtils.round(posX, RoundingMode.DOWN), MathUtils.round(posY, RoundingMode.DOWN), MathUtils.round(posZ, RoundingMode.DOWN), dim));
        this.func_76185_a();
    }

    public void clearLastDeath(UUID id) {
        this.deaths.remove(id);
        this.func_76185_a();
    }

    public Waypoint getLastDeath(UUID id) {
        return this.deaths.get(id);
    }

    public boolean func_76188_b() {
        return true;
    }
}

