/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.block;

import com.ferreusveritas.warpbook.WarpBookMod;
import com.ferreusveritas.warpbook.block.IColorableBlock;
import com.ferreusveritas.warpbook.core.WarpColors;
import com.ferreusveritas.warpbook.item.WarpPotionItem;
import com.ferreusveritas.warpbook.tileentity.TileEntityTeleporter;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTeleporter
extends Block
implements ITileEntityProvider,
IColorableBlock {
    protected static final AxisAlignedBB TELEPORTER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockTeleporter() {
        super(Material.field_151573_f);
        this.func_149663_c("teleporter");
        this.setRegistryName("teleporter");
        this.func_149647_a(WarpBookMod.tabBook);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTeleporter();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            IBlockState newState = state;
            TileEntityTeleporter teleporter = (TileEntityTeleporter)world.func_175625_s(pos);
            if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof WarpPotionItem) {
                teleporter.setWarpItem(player.func_184586_b(hand));
                if (player.func_184586_b(hand).func_190916_E() < 1) {
                    player.func_184586_b(hand).func_190918_g(1);
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
                player.func_191521_c(new ItemStack(Items.field_151069_bo));
            }
            world.func_184138_a(pos, state, newState, 3);
            teleporter.func_70296_d();
        }
        return true;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        ItemStack page;
        if (entityIn instanceof EntityPlayer && !(page = ((TileEntityTeleporter)worldIn.func_175625_s(pos)).getWarpItem()).func_190926_b()) {
            WarpBookMod.warpDrive.queueWarp((EntityPlayer)entityIn, page);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TELEPORTER_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColor(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        TileEntityTeleporter teleporter = (TileEntityTeleporter)world.func_175625_s(pos);
        if (teleporter instanceof TileEntityTeleporter) {
            WarpColors wc = teleporter.getWarpColor();
            if (wc == WarpColors.UNBOUND) {
                return -7829368;
            }
            switch (tintIndex) {
                default: {
                    return -1;
                }
                case 0: {
                    return wc.getColor();
                }
                case 1: 
            }
            return wc.getSpecColor();
        }
        return -1;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

