/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.commands;

import com.ferreusveritas.warpbook.WarpWorldStorage;
import com.ferreusveritas.warpbook.util.CommandUtils;
import com.ferreusveritas.warpbook.util.Waypoint;
import java.util.ArrayList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.translation.I18n;

public class ListWaypointCommand
extends CommandBase {
    public String func_71517_b() {
        return "waypointlist";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/waypointlist [page]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        WarpWorldStorage storage = WarpWorldStorage.get(sender.func_130014_f_());
        try {
            int page = args.length == 0 ? 0 : CommandBase.func_175755_a((String)args[0]);
            ArrayList<String> wps = new ArrayList<String>(storage.listWaypoints());
            if (wps.size() == 0) {
                CommandUtils.showError(sender, I18n.func_74838_a((String)"help.nowaypointsfound").trim());
                return;
            }
            CommandUtils.info(sender, String.format("-- Page %d --", page));
            for (int i = page * 8; i < page * 8 + 9; ++i) {
                try {
                    Waypoint wp = storage.getWaypoint((String)wps.get(i));
                    CommandUtils.info(sender, wp.name + " [ " + wp.x + ", " + wp.y + ", " + wp.z + " ] Dim: " + wp.dim + ", Info: \"" + wp.friendlyName + "\"");
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            CommandUtils.info(sender, String.format("-- Page %d --", page));
        }
        catch (Exception e) {
            CommandUtils.printUsage(sender, this);
            CommandUtils.showError(sender, CommandUtils.ChatType.TYPE_int, e.getLocalizedMessage());
        }
    }

    public int compareTo(ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }
}

