/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.core;

import com.ferreusveritas.warpbook.WarpBookMod;
import com.ferreusveritas.warpbook.core.IDeclareWarp;
import com.ferreusveritas.warpbook.net.packet.PacketEffect;
import com.ferreusveritas.warpbook.util.CommandUtils;
import com.ferreusveritas.warpbook.util.MathUtils;
import com.ferreusveritas.warpbook.util.Waypoint;
import java.math.RoundingMode;
import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Teleporter;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WarpDrive {
    public boolean queueWarp(EntityPlayer player, ItemStack warpItem) {
        if (!player.field_70170_p.field_72995_K && warpItem.func_77973_b() instanceof IDeclareWarp) {
            Waypoint wp = ((IDeclareWarp)warpItem.func_77973_b()).getWaypoint(player, warpItem);
            if (wp == null) {
                CommandUtils.showError((ICommandSender)player, I18n.func_135052_a((String)"help.waypointnotexist", (Object[])new Object[0]));
            }
            if (player.getEntityData().func_74764_b("warpbook")) {
                return false;
            }
            if (Arrays.asList(WarpBookMod.disabledDestinations).contains(new Integer(wp.dim))) {
                CommandUtils.showError((ICommandSender)player, I18n.func_135052_a((String)"help.cantgoto", (Object[])new Object[0]));
                return false;
            }
            if (Arrays.asList(WarpBookMod.disabledLeaving).contains(new Integer(player.field_71093_bK))) {
                CommandUtils.showError((ICommandSender)player, I18n.func_135052_a((String)"help.cantleave", (Object[])new Object[0]));
                return false;
            }
            NBTTagCompound wpData = new NBTTagCompound();
            wp.writeToNBT(wpData);
            player.getEntityData().func_74782_a("warpbook", (NBTBase)wpData);
        }
        return true;
    }

    public void processWarp(EntityPlayer player, Waypoint wp) {
        boolean crossDim;
        PacketEffect oldDim = new PacketEffect(true, MathUtils.round(player.field_70165_t, RoundingMode.DOWN), MathUtils.round(player.field_70163_u, RoundingMode.DOWN), MathUtils.round(player.field_70161_v, RoundingMode.DOWN));
        PacketEffect newDim = new PacketEffect(false, wp.x, wp.y, wp.z);
        NetworkRegistry.TargetPoint oldPoint = new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0);
        NetworkRegistry.TargetPoint newPoint = new NetworkRegistry.TargetPoint(wp.dim, (double)wp.x, (double)wp.y, (double)wp.z, 64.0);
        boolean bl = crossDim = player.field_71093_bK != wp.dim;
        if (crossDim) {
            if (!ForgeHooks.onTravelToDimension((Entity)player, (int)wp.dim)) {
                return;
            }
            if (player.func_70613_aW()) {
                player.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, wp.dim, new Teleporter(((EntityPlayerMP)player).func_71121_q()){

                    public void func_180266_a(Entity entityIn, float rotationYaw) {
                    }

                    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
                        return true;
                    }

                    public boolean func_85188_a(Entity entityIn) {
                        return true;
                    }

                    public void func_85189_a(long worldTime) {
                    }
                });
            }
        }
        player.func_71020_j(WarpDrive.calculateExhaustion(player.func_130014_f_().func_175659_aa(), WarpBookMod.exhaustionCoefficient, crossDim));
        player.func_70634_a((double)wp.x + 0.5, (double)wp.y + 0.5, (double)wp.z + 0.5);
        WarpBookMod.network.sendToAllAround((IMessage)oldDim, oldPoint);
        WarpBookMod.network.sendToAllAround((IMessage)newDim, newPoint);
    }

    private static float calculateExhaustion(EnumDifficulty difficultySetting, float exhaustionCoefficient, boolean crossDim) {
        float scaleFactor = 0.0f;
        switch (difficultySetting) {
            case EASY: {
                scaleFactor = 1.0f;
                break;
            }
            case NORMAL: {
                scaleFactor = 1.5f;
                break;
            }
            case HARD: {
                scaleFactor = 2.0f;
                break;
            }
            case PEACEFUL: {
                scaleFactor = 0.0f;
            }
        }
        return exhaustionCoefficient * scaleFactor * (crossDim ? 2.0f : 1.0f);
    }
}

