/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.util;

import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandUtils {
    private static final Style errorStyle = new Style();
    private static final Style usageStyle;
    private static final Style infoStyle;

    public static void printUsage(ICommandSender sender, CommandBase createWaypointCommand) {
        TextComponentString prefix = new TextComponentString("Usage:");
        TextComponentString usage = new TextComponentString(createWaypointCommand.func_71518_a(sender));
        prefix.func_150255_a(usageStyle);
        usage.func_150255_a(usageStyle);
        sender.func_145747_a((ITextComponent)prefix);
        sender.func_145747_a((ITextComponent)usage);
    }

    public static void showError(ICommandSender sender, ChatType type, String string) {
        CommandUtils.showError(sender, String.format("'%s' is not a valid %s", string, CommandUtils.getFriendlyName(type)));
    }

    public static void showError(ICommandSender sender, String message) {
        TextComponentString text = new TextComponentString(message);
        text.func_150255_a(errorStyle);
        sender.func_145747_a((ITextComponent)text);
    }

    private static String getFriendlyName(ChatType type) {
        switch (type) {
            case TYPE_int: {
                return "integer";
            }
            case TYPE_player: {
                return "player";
            }
        }
        return "duck";
    }

    public static String stringConcat(String[] var2, int start) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < var2.length; ++i) {
            builder.append(var2[i]);
            builder.append(" ");
        }
        if (var2.length > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static void info(ICommandSender sender, String message) {
        TextComponentString text = new TextComponentString(message);
        text.func_150255_a(infoStyle);
        sender.func_145747_a((ITextComponent)text);
    }

    static {
        errorStyle.func_150238_a(TextFormatting.RED);
        usageStyle = new Style();
        usageStyle.func_150238_a(TextFormatting.YELLOW);
        infoStyle = new Style();
        infoStyle.func_150238_a(TextFormatting.WHITE);
    }

    public static enum ChatType {
        TYPE_int,
        TYPE_player;

    }
}

