/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IBCoreBlock;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.registry.ModFeatureParser;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBCore
extends Block
implements IBCoreBlock {
    public static final String TILE_DATA_TAG = "BCTileData";
    protected boolean isFullCube = true;
    private boolean ifcSet = false;
    protected boolean canProvidePower = false;
    protected boolean hasSubItemTypes = false;
    public Map<Integer, String> nameOverrides = new HashMap<Integer, String>();

    public BlockBCore() {
        this(Material.field_151576_e);
    }

    public BlockBCore(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        super.func_149666_a(tab, list);
    }

    public BlockBCore setHarvestTool(String toolClass, int level) {
        this.setHarvestLevel(toolClass, level);
        return this;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (stack.func_77973_b() == Item.func_150898_a((Block)this) && stack.func_77973_b().func_77614_k()) {
            stack.func_77964_b(this.func_176201_c(state));
        }
        if ((tile = world.func_175625_s(pos)) instanceof IDataRetainingTile && !BrandonsCore.proxy.isCTRLKeyDown()) {
            NBTTagCompound tileData = new NBTTagCompound();
            ((IDataRetainingTile)tile).writeToItemStack(tileData, false);
            if (!tileData.func_82582_d()) {
                ItemNBTHelper.getCompound(stack).func_74782_a(TILE_DATA_TAG, (NBTBase)tileData);
            }
        }
        return stack;
    }

    @Deprecated
    public BlockBCore setIsFullCube(boolean value) {
        this.isFullCube = value;
        this.ifcSet = true;
        return this;
    }

    public boolean uberIsBlockFullCube() {
        return !this.ifcSet || this.isFullCube;
    }

    public BlockBCore addName(int meta, String name) {
        this.nameOverrides.put(meta, name);
        this.setHasSubItemTypes(true);
        return this;
    }

    public BlockBCore setHasSubItemTypes(boolean hasSubItemTypes) {
        this.hasSubItemTypes = hasSubItemTypes;
        return this;
    }

    @Override
    public boolean hasSubItemTypes() {
        return this.hasSubItemTypes;
    }

    @Override
    public Map<Integer, String> getNameOverrides() {
        return this.nameOverrides;
    }

    public boolean isBlockEnabled() {
        return ModFeatureParser.isEnabled(this);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.hasTileEntity(state)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof IRedstoneEmitter || this.canProvidePower;
        }
        return super.canConnectRedstone(state, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.hasTileEntity(state)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof IChangeListener;
        }
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (this.hasTileEntity(blockState) && (tile = blockAccess.func_175625_s(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getWeakPower(blockState, side);
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (this.hasTileEntity(blockState) && (tile = blockAccess.func_175625_s(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getStrongPower(blockState, side);
        }
        return super.func_176211_b(blockState, blockAccess, pos, side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (this.hasTileEntity(state) && (tile = world.func_175625_s(pos)) instanceof IChangeListener) {
            ((IChangeListener)tile).onNeighborChange(fromPos);
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (this.hasTileEntity(state) && (tile = worldIn.func_175625_s(pos)) instanceof IActivatableTile) {
            return ((IActivatableTile)tile).onBlockActivated(state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IDataRetainingTile && stack.func_77942_o() && stack.func_77978_p().func_74764_b(TILE_DATA_TAG)) {
            ((IDataRetainingTile)tile).readFromItemStack(stack.func_179543_a(TILE_DATA_TAG));
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack heldStack) {
        if (te instanceof IDataRetainingTile && ((IDataRetainingTile)te).saveToItem()) {
            ItemStack stack = new ItemStack((Block)this, 1, this.func_180651_a(state));
            NBTTagCompound tileData = new NBTTagCompound();
            ((IDataRetainingTile)te).writeToItemStack(tileData, true);
            if (!tileData.func_82582_d()) {
                ItemNBTHelper.getCompound(stack).func_74782_a(TILE_DATA_TAG, (NBTBase)tileData);
            }
            BlockBCore.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            world.func_175713_t(pos);
        } else {
            super.func_180657_a(world, player, pos, state, te, heldStack);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return this.uberIsBlockFullCube();
    }

    public boolean func_149662_c(IBlockState state) {
        return this.uberIsBlockFullCube();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TILE_DATA_TAG)) {
            tooltip.add(I18n.func_135052_a((String)"info.de.hasSavedData.txt", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean overrideShareTag() {
        return false;
    }

    @Override
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return stack.func_77978_p();
    }
}

