/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat;

import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import net.minecraftforge.fml.common.Optional;

public final class LuaHelper {
    private static final String MODID_OPENCOMPUTERS = "opencomputers";

    public static void validateArgsCount(@Nonnull Object[] arguments, int count) throws Exception {
        if (arguments.length < count) {
            LuaHelper.raiseInvalidArgsCount(count);
        }
    }

    @Optional.Method(modid="opencomputers")
    public static void validateArgsCount(@Nonnull Arguments arguments, int count) throws Exception {
        if (arguments.count() < count) {
            LuaHelper.raiseInvalidArgsCount(count);
        }
    }

    public static double getDoubleFromArgs(@Nonnull Object[] arguments, int index) throws Exception {
        if (null == arguments[index] || !(arguments[index] instanceof Double)) {
            LuaHelper.raiseIllegalArgumentType(index, "Number");
        }
        return (Double)arguments[index];
    }

    @Optional.Method(modid="opencomputers")
    public static double getDoubleFromArgs(@Nonnull Arguments arguments, int index) throws Exception {
        if (!arguments.isDouble(index)) {
            LuaHelper.raiseIllegalArgumentType(index, "Number");
        }
        return arguments.checkDouble(index);
    }

    public static double getDoubleFromArgs(@Nonnull Object[] arguments, int index, double minValue, double maxValue) throws Exception {
        double value = LuaHelper.getDoubleFromArgs(arguments, index);
        if (value < minValue || value > maxValue) {
            LuaHelper.raiseIllegalArgumentRange(index, minValue, maxValue);
        }
        return value;
    }

    @Optional.Method(modid="opencomputers")
    public static double getDoubleFromArgs(@Nonnull Arguments arguments, int index, double minValue, double maxValue) throws Exception {
        double value = LuaHelper.getDoubleFromArgs(arguments, index);
        if (value < minValue || value > maxValue) {
            LuaHelper.raiseIllegalArgumentRange(index, minValue, maxValue);
        }
        return value;
    }

    public static int getIntFromArgs(@Nonnull Object[] arguments, int index) throws Exception {
        return (int)Math.round(LuaHelper.getDoubleFromArgs(arguments, index));
    }

    @Optional.Method(modid="opencomputers")
    public static int getIntFromArgs(@Nonnull Arguments arguments, int index) throws Exception {
        return (int)Math.round(LuaHelper.getDoubleFromArgs(arguments, index));
    }

    public static int getIntFromArgs(@Nonnull Object[] arguments, int index, int minValue, int maxValue) throws Exception {
        int value = LuaHelper.getIntFromArgs(arguments, index);
        if (value < minValue || value > maxValue) {
            LuaHelper.raiseIllegalArgumentRange(index, minValue, maxValue);
        }
        return value;
    }

    @Optional.Method(modid="opencomputers")
    public static int getIntFromArgs(@Nonnull Arguments arguments, int index, int minValue, int maxValue) throws Exception {
        int value = LuaHelper.getIntFromArgs(arguments, index);
        if (value < minValue || value > maxValue) {
            LuaHelper.raiseIllegalArgumentRange(index, minValue, maxValue);
        }
        return value;
    }

    public static boolean getBooleanFromArgs(@Nonnull Object[] arguments, int index) throws Exception {
        if (null == arguments[index] || !(arguments[index] instanceof Boolean)) {
            LuaHelper.raiseIllegalArgumentType(index, "Boolean");
        }
        return (Boolean)arguments[index];
    }

    @Optional.Method(modid="opencomputers")
    public static boolean getBooleanFromArgs(@Nonnull Arguments arguments, int index) throws Exception {
        if (!arguments.isBoolean(index)) {
            LuaHelper.raiseIllegalArgumentType(index, "Boolean");
        }
        return arguments.checkBoolean(index);
    }

    public static String getStringFromArgs(@Nonnull Object[] arguments, int index) throws Exception {
        if (null == arguments[index] || !(arguments[index] instanceof String)) {
            LuaHelper.raiseIllegalArgumentType(index, "String");
        }
        return (String)arguments[index];
    }

    @Optional.Method(modid="opencomputers")
    public static String getStringFromArgs(@Nonnull Arguments arguments, int index) throws Exception {
        if (!arguments.isString(index)) {
            LuaHelper.raiseIllegalArgumentType(index, "String");
        }
        return arguments.checkString(index);
    }

    public static void raiseInvalidArgsCount(int expectedCount) {
        throw new IllegalArgumentException(String.format("Insufficient number of arguments, expected %d", expectedCount));
    }

    public static void raiseIllegalArgumentType(int index, String expectedType) {
        throw new IllegalArgumentException(String.format("Invalid argument %d, expected %s", index, expectedType));
    }

    public static void raiseIllegalArgumentRange(int index, double minValue, double maxValue) {
        throw new IllegalArgumentException(String.format("Invalid argument %d, valid range is %f : %f", index, minValue, maxValue));
    }

    public static void raiseIllegalArgumentRange(int index, int minValue, int maxValue) {
        throw new IllegalArgumentException(String.format("Invalid argument %d, valid range is %d : %d", index, minValue, maxValue));
    }

    private LuaHelper() {
    }
}

