/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.world.IWorldGenWhiteList;
import it.zerono.mods.zerocore.lib.world.ModWorldGeneratorBase;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenMinableOres
extends ModWorldGeneratorBase {
    private List<VeinGenerator> _generators;

    public WorldGenMinableOres(IWorldGenWhiteList whiteList) {
        this(whiteList, false);
    }

    public WorldGenMinableOres(IWorldGenWhiteList whiteList, boolean useBlackListLogic) {
        super(whiteList, useBlackListLogic);
    }

    public void addOre(Block ore, Block blockToReplace, int minY, int maxY, int maxBlockCount, int iterations) {
        this.addOre(ore.func_176223_P(), blockToReplace.func_176223_P(), minY, maxY, maxBlockCount, iterations);
    }

    public void addOre(IBlockState ore, IBlockState blockToReplace, int minY, int maxY, int maxBlockCount, int iterations) {
        if (null == ore || null == blockToReplace) {
            throw new IllegalArgumentException("Illegal ore or target block");
        }
        if (minY < 0 || maxY < minY || maxY > 256) {
            throw new IllegalArgumentException("Invalid Y coordinates");
        }
        if (maxBlockCount <= 0) {
            throw new IllegalArgumentException("maxBlockCount should be greather than zero");
        }
        if (iterations <= 0) {
            throw new IllegalArgumentException("Invalid number of iterations");
        }
        if (null == this._generators) {
            this._generators = Lists.newArrayList();
        }
        this._generators.add(new VeinGenerator(ore, blockToReplace, minY, maxY, maxBlockCount, iterations));
    }

    public void clearOres() {
        if (null != this._generators) {
            this._generators.clear();
        }
    }

    @Override
    protected void generateChunk(Random random, int firstBlockX, int firstBlockZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateChunk(random, firstBlockX, firstBlockZ, world);
    }

    public void generateChunk(Random random, int firstBlockX, int firstBlockZ, World world) {
        if (null == this._generators || this._generators.isEmpty()) {
            return;
        }
        for (VeinGenerator generator : this._generators) {
            for (int iteration = 0; iteration < generator.iterations; ++iteration) {
                int y = generator.minY + random.nextInt(generator.maxY - generator.minY);
                BlockPos position = new BlockPos(firstBlockX, y, firstBlockZ);
                generator.func_180709_b(world, random, position);
            }
        }
    }

    private class VeinGenerator
    extends WorldGenMinable {
        final int minY;
        final int maxY;
        final int iterations;

        VeinGenerator(IBlockState ore, final IBlockState blockToReplace, int minY, int maxY, int maxBlockCount, int iterations) {
            super(ore, maxBlockCount, (Predicate)new Predicate<IBlockState>(){
                private final Block _targetBlock;
                {
                    this._targetBlock = blockToReplace.func_177230_c();
                }

                public boolean apply(@Nullable IBlockState input) {
                    return null != input && input.func_177230_c() == this._targetBlock && input.func_177230_c().func_176201_c(input) == this._targetBlock.func_176201_c(input);
                }

                public boolean test(@Nullable IBlockState input) {
                    return this.apply(input);
                }
            });
            this.minY = minY;
            this.maxY = maxY;
            this.iterations = iterations;
        }
    }
}

