/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.McJtyRegister;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.multipart.MultipartBakedModel;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartItemBlock;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.multipart.PartsProperty;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultipartBlock
extends Block
implements WailaInfoProvider,
TOPInfoProvider,
ITileEntityProvider {
    public static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB AABB_CENTER = new AxisAlignedBB(0.4, 0.4, 0.4, 0.6, 0.6, 0.6);
    public static final PartsProperty PARTS = new PartsProperty("parts");

    public MultipartBlock() {
        super(Material.field_151573_f);
        this.func_149663_c("mcjtylib_ng.multipart");
        this.setRegistryName("multipart");
        McJtyRegister.registerLater((Block)this, McJtyLib.instance, MultipartItemBlock::new);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new MultipartTE();
    }

    public void initModel() {
        McJtyLib.proxy.initStandardItemModel(this);
        McJtyLib.proxy.initStateMapper(this, MultipartBakedModel.MODEL);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{PARTS};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        MultipartTE.Part part = this.getHitPart(state, world, pos, player.func_174824_e(0.0f), target.field_72307_f);
        if (part != null) {
            return new ItemStack(Item.func_150898_a((Block)part.getState().func_177230_c()));
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE multipartTE = (MultipartTE)te;
            for (Map.Entry<PartSlot, MultipartTE.Part> entry : multipartTE.getParts().entrySet()) {
                MultipartTE.Part part = entry.getValue();
                MultipartBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)part.getState().func_185890_d((IBlockAccess)world, pos));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return AABB_EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Vec3d end;
        Vec3d start = MultipartHelper.getPlayerEyes(player);
        MultipartTE.Part part = this.getHitPart(state, world, pos, start, end = new Vec3d(start.field_72450_a + ((double)((float)pos.func_177958_n() + hitX) - start.field_72450_a) * 3.0, start.field_72448_b + ((double)((float)pos.func_177956_o() + hitY) - start.field_72448_b) * 3.0, start.field_72449_c + ((double)((float)pos.func_177952_p() + hitZ) - start.field_72449_c) * 3.0));
        if (part != null) {
            if (part.getTileEntity() instanceof GenericTileEntity) {
                return ((GenericTileEntity)part.getTileEntity()).onBlockActivated(part.getState(), player, hand, facing, hitX, hitY, hitZ);
            }
            return part.getState().func_177230_c().func_180639_a(world, pos, part.getState(), player, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    @Nullable
    public IBlockState getHitState(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        MultipartTE.Part part = this.getHitPart(blockState, world, pos, start, end);
        if (part != null) {
            return part.getState();
        }
        return null;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE multipartTE = (MultipartTE)te;
            for (Map.Entry<PartSlot, MultipartTE.Part> entry : multipartTE.getParts().entrySet()) {
                RayTraceResult result;
                MultipartTE.Part part = entry.getValue();
                if (part.getState().func_177230_c() instanceof MultipartBlock || (result = part.getState().func_185910_a(world, pos, start, end)) == null) continue;
                return result;
            }
            return null;
        }
        return super.func_180636_a(blockState, world, pos, start, end);
    }

    @Nullable
    public MultipartTE.Part getHitPart(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE multipartTE = (MultipartTE)te;
            for (Map.Entry<PartSlot, MultipartTE.Part> entry : multipartTE.getParts().entrySet()) {
                RayTraceResult result;
                MultipartTE.Part part = entry.getValue();
                if (part.getState().func_177230_c() instanceof MultipartBlock || (result = part.getState().func_185910_a(world, pos, start, end)) == null) continue;
                return part;
            }
            return null;
        }
        return null;
    }

    private RayTraceResult checkIntersect(BlockPos pos, Vec3d vec3d, Vec3d vec3d1, AxisAlignedBB boundingBox) {
        RayTraceResult raytraceresult = boundingBox.func_72327_a(vec3d, vec3d1);
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos);
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        MultipartTE.Part part = this.getHitPart(blockState, world, data.getPos(), MultipartHelper.getPlayerEyes(player), data.getHitVec());
        if (part != null) {
            if (part.getTileEntity() instanceof GenericTileEntity) {
                ((GenericTileEntity)part.getTileEntity()).addProbeInfo(mode, probeInfo, player, world, blockState, data);
            } else if (part.getState().func_177230_c() instanceof TOPInfoProvider) {
                ((TOPInfoProvider)part.getState().func_177230_c()).addProbeInfo(mode, probeInfo, player, world, blockState, data);
            }
        }
    }

    @Override
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MultipartTE.Part part = this.getHitPart(accessor.getBlockState(), accessor.getWorld(), accessor.getPosition(), MultipartHelper.getPlayerEyes(accessor.getPlayer()), accessor.getRenderingPosition());
        if (part != null) {
            if (part.getTileEntity() instanceof GenericTileEntity) {
                ((GenericTileEntity)part.getTileEntity()).addWailaBody(itemStack, currenttip, accessor, config);
            } else if (part.getState().func_177230_c() instanceof WailaInfoProvider) {
                return ((WailaInfoProvider)part.getState().func_177230_c()).getWailaBody(itemStack, currenttip, accessor, config);
            }
        }
        return currenttip;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE multipartTE = (MultipartTE)te;
            return extendedBlockState.withProperty((IUnlistedProperty)PARTS, multipartTE.getParts());
        }
        return extendedBlockState;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }
}

