/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.Infusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.NullSidedInvWrapper;
import mcjty.lib.varia.RedstoneMode;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.lwjgl.input.Keyboard;

public class GenericTileEntity
extends TileEntity
implements ICommandHandler,
IClientCommandHandler {
    public static final IValue<?>[] EMPTY_VALUES = new IValue[0];
    public static final IAction[] EMPTY_ACTIONS = new IAction[0];
    public static final String COMMAND_SYNC_BINDING = "generic.syncBinding";
    public static final String COMMAND_SYNC_ACTION = "generic.syncAction";
    public static final Key<String> PARAM_KEY = new Key<String>("key", Type.STRING);
    public static final Key<Integer> VALUE_RSMODE = new Key<Integer>("rsmode", Type.INTEGER);
    private String displayName = null;
    private int infused = 0;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private int securityChannel = -1;
    protected RedstoneMode rsMode = RedstoneMode.REDSTONE_IGNORED;
    protected int powerLevel = 0;
    protected IItemHandler invHandlerNull;
    protected IItemHandler invHandlerSided;

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void markDirtyQuick() {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public IValue<?>[] getValues() {
        return EMPTY_VALUES;
    }

    public IAction[] getActions() {
        return EMPTY_ACTIONS;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
    }

    public void onPartAdded(PartSlot slot, IBlockState state, TileEntity multipartTile) {
    }

    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    protected boolean needsRedstoneMode() {
        return false;
    }

    public void checkRedstone(World world, BlockPos pos) {
        int powered = world.func_175687_A(pos);
        this.setPowerInput(powered);
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = powered;
            this.func_70296_d();
        }
    }

    public RedstoneMode getRSMode() {
        return this.rsMode;
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        this.rsMode = redstoneMode;
        this.markDirtyClient();
    }

    public void setRSModeInt(int i) {
        this.rsMode = RedstoneMode.values()[i];
        this.markDirtyClient();
    }

    public int getRSModeInt() {
        return this.rsMode.ordinal();
    }

    public boolean isMachineEnabled() {
        if (this.rsMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powerLevel > 0;
            if (this.rsMode == RedstoneMode.REDSTONE_OFFREQUIRED && rs) {
                return false;
            }
            if (this.rsMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                return false;
            }
        }
        return true;
    }

    public void onSlotChanged(int index, ItemStack stack) {
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeClientDataToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readClientDataFromNBT(packet.func_148857_g());
    }

    public void setInfused(int infused) {
        this.infused = infused;
        this.markDirtyClient();
    }

    public int getInfused() {
        return this.infused;
    }

    public float getInfusedFactor() {
        return (float)this.infused / (float)GeneralConfig.maxInfuse;
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.writeClientDataToNBT(updateTag);
        return updateTag;
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        this.func_189515_b(tagCompound);
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.func_145839_a(tagCompound);
    }

    public void syncDataForGUI(Object[] data) {
    }

    public Object[] getDataForGUI() {
        return new Object[0];
    }

    protected void readBufferFromNBT(NBTTagCompound tagCompound, InventoryHelper inventoryHelper) {
        this.readBufferFromNBT(tagCompound, "Items", inventoryHelper.getStacks());
    }

    protected void readBufferFromNBT(NBTTagCompound tagCompound, String tag, ItemStackList list) {
        NBTTagList bufferTagList = tagCompound.func_150295_c(tag, 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            if (i >= list.size()) continue;
            list.set(i, new ItemStack(nbtTagCompound));
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerLevel = tagCompound.func_74771_c("powered");
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound display;
        if (this.needsRedstoneMode()) {
            byte m = tagCompound.func_74771_c("rsMode");
            this.rsMode = RedstoneMode.values()[m];
        }
        if ((display = tagCompound.func_74775_l("display")).func_150297_b("Name", 8)) {
            this.displayName = display.func_74779_i("Name");
        }
        this.infused = tagCompound.func_74762_e("infused");
        this.ownerName = tagCompound.func_74779_i("owner");
        this.ownerUUID = tagCompound.func_74764_b("idM") ? new UUID(tagCompound.func_74763_f("idM"), tagCompound.func_74763_f("idL")) : null;
        this.securityChannel = tagCompound.func_74764_b("secChannel") ? tagCompound.func_74762_e("secChannel") : -1;
    }

    protected void writeBufferToNBT(NBTTagCompound tagCompound, String tag, ItemStackList list) {
        NBTTagList bufferTagList = new NBTTagList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a(tag, (NBTBase)bufferTagList);
    }

    protected void writeBufferToNBT(NBTTagCompound tagCompound, InventoryHelper inventoryHelper) {
        this.writeBufferToNBT(tagCompound, "Items", inventoryHelper.getStacks());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.powerLevel > 0) {
            tagCompound.func_74774_a("powered", (byte)this.powerLevel);
        }
        this.writeRestorableToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        if (this.needsRedstoneMode()) {
            tagCompound.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        }
        if (this.displayName != null) {
            NBTTagCompound display = tagCompound.func_74775_l("display");
            display.func_74778_a("Name", this.displayName);
            tagCompound.func_74782_a("display", (NBTBase)display);
        }
        tagCompound.func_74768_a("infused", this.infused);
        tagCompound.func_74778_a("owner", this.ownerName);
        if (this.ownerUUID != null) {
            tagCompound.func_74772_a("idM", this.ownerUUID.getMostSignificantBits());
            tagCompound.func_74772_a("idL", this.ownerUUID.getLeastSignificantBits());
        }
        if (this.securityChannel != -1) {
            tagCompound.func_74768_a("secChannel", this.securityChannel);
        }
    }

    public boolean setOwner(EntityPlayer player) {
        if (!GeneralConfig.manageOwnership) {
            return false;
        }
        if (this.ownerUUID != null) {
            return false;
        }
        this.ownerUUID = player.func_146103_bH().getId();
        this.ownerName = player.func_70005_c_();
        this.markDirtyClient();
        return true;
    }

    public void clearOwner() {
        if (!GeneralConfig.manageOwnership) {
            return;
        }
        this.ownerUUID = null;
        this.ownerName = "";
        this.securityChannel = -1;
        this.markDirtyClient();
    }

    public void setSecurityChannel(int id) {
        this.securityChannel = id;
        this.markDirtyClient();
    }

    public int getSecurityChannel() {
        return this.securityChannel;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        return Collections.emptyList();
    }

    @Override
    public TypedMap executeWithResult(String command, TypedMap args) {
        return null;
    }

    @Override
    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        return false;
    }

    @Override
    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        return false;
    }

    protected boolean needsCustomInvWrapper() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.needsCustomInvWrapper() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.needsCustomInvWrapper()) {
            if (facing == null) {
                if (this.invHandlerNull == null) {
                    this.invHandlerNull = new InvWrapper((IInventory)this);
                }
                return (T)this.invHandlerNull;
            }
            if (this.invHandlerSided == null) {
                this.invHandlerSided = new NullSidedInvWrapper((ISidedInventory)this);
            }
            return (T)this.invHandlerSided;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean checkAccess(EntityPlayer player) {
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (blockState.func_177230_c() instanceof Infusable) {
            int infused = this.getInfused();
            int pct = infused * 100 / GeneralConfig.maxInfuse;
            probeInfo.text(TextFormatting.YELLOW + "Infused: " + pct + "%");
        }
        if (mode == ProbeMode.EXTENDED && GeneralConfig.manageOwnership && this.getOwnerName() != null && !this.getOwnerName().isEmpty()) {
            int securityChannel = this.getSecurityChannel();
            if (securityChannel == -1) {
                probeInfo.text(TextFormatting.YELLOW + "Owned by: " + this.getOwnerName());
            } else {
                probeInfo.text(TextFormatting.YELLOW + "Owned by: " + this.getOwnerName() + " (channel " + securityChannel + ")");
            }
            if (this.getOwnerUUID() == null) {
                probeInfo.text(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block instanceof Infusable) {
            int infused = this.getInfused();
            int pct = infused * 100 / GeneralConfig.maxInfuse;
            currenttip.add(TextFormatting.YELLOW + "Infused: " + pct + "%");
        }
        if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && GeneralConfig.manageOwnership && this.getOwnerName() != null && !this.getOwnerName().isEmpty()) {
            int securityChannel = this.getSecurityChannel();
            if (securityChannel == -1) {
                currenttip.add(TextFormatting.YELLOW + "Owned by: " + this.getOwnerName());
            } else {
                currenttip.add(TextFormatting.YELLOW + "Owned by: " + this.getOwnerName() + " (channel " + securityChannel + ")");
            }
            if (this.getOwnerUUID() == null) {
                currenttip.add(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
            }
        }
    }

    public IBlockState getActualState(IBlockState state) {
        return state;
    }

    public int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return -1;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
    }

    public void rotateBlock(EnumFacing axis) {
    }

    public boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        return false;
    }

    private <V> Consumer<V> findSetter(Key<V> key) {
        for (IValue<?> value : this.getValues()) {
            if (!key.getName().equals(value.getKey().getName())) continue;
            return value.setter();
        }
        return null;
    }

    private Runnable findConsumer(String key) {
        for (IAction action : this.getActions()) {
            if (!key.equals(action.getKey())) continue;
            return action.consumer();
        }
        return null;
    }

    public <T> void valueToServer(SimpleNetworkWrapper network, Key<T> valueKey, T value) {
        network.sendToServer((IMessage)new PacketServerCommandTyped(this.func_174877_v(), COMMAND_SYNC_BINDING, TypedMap.builder().put(valueKey, value).build()));
    }

    public void requestDataFromServer(String modid, String command, @Nonnull TypedMap params) {
        PacketHandler.modNetworking.get(modid).sendToServer((IMessage)new PacketRequestDataFromServer(modid, this.field_174879_c, command, params));
    }

    @Override
    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        if (COMMAND_SYNC_BINDING.equals(command)) {
            this.syncBinding(params);
            return true;
        }
        if (COMMAND_SYNC_ACTION.equals(command)) {
            String key = params.get(PARAM_KEY);
            this.findConsumer(key).run();
            return true;
        }
        return false;
    }

    private <T> void syncBindingHelper(TypedMap params, Key<T> bkey) {
        T o = params.get(bkey);
        this.findSetter(bkey).accept(o);
    }

    private void syncBinding(TypedMap params) {
        for (Key<?> key : params.getKeys()) {
            this.syncBindingHelper(params, key);
        }
        this.markDirtyClient();
    }
}

