/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HarvestCraftAddon {
    private boolean cuttingBoardFound;

    public HarvestCraftAddon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Compat.cuttingBoardItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("harvestcraft", "cuttingboarditem"));
        if (Compat.cuttingBoardItem != null && Compat.cuttingBoardItem != Items.field_190931_a) {
            CookingForBlockheads.extraCreativeTabItems.add((Object)new ItemStack(Compat.cuttingBoardItem));
            this.cuttingBoardFound = true;
        }
    }

    public static boolean isWeirdConversionRecipe(IRecipe recipe) {
        if (recipe.func_192400_c().size() == 2 && recipe.func_77571_b().func_190916_E() == 2) {
            Ingredient first = (Ingredient)recipe.func_192400_c().get(0);
            Ingredient second = (Ingredient)recipe.func_192400_c().get(1);
            if (first.apply(recipe.func_77571_b()) && second.apply(recipe.func_77571_b())) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!this.cuttingBoardFound) {
            return;
        }
        if (event.getItemStack().func_77973_b() == Compat.cuttingBoardItem) {
            event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cookingforblockheads:multiblock_kitchen", (Object[])new Object[0]));
            event.getToolTip().add(I18n.func_135052_a((String)"tooltip.cookingforblockheads:can_be_placed_in_world", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!this.cuttingBoardFound) {
            return;
        }
        if (event.getItemStack().func_77973_b() != Compat.cuttingBoardItem) {
            return;
        }
        if (event.getFace() != EnumFacing.UP) {
            return;
        }
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        IBlockState clickedBlock = world.func_180495_p(event.getPos());
        if (clickedBlock.func_177230_c() == Blocks.field_150486_ae || clickedBlock.func_177230_c() == Blocks.field_150462_ai || clickedBlock.func_177230_c() == ModBlocks.cuttingBoard) {
            return;
        }
        BlockPos pos = event.getPos().func_177972_a(event.getFace());
        if (world.func_190527_a(ModBlocks.cuttingBoard, pos, false, event.getFace(), (Entity)player)) {
            IBlockState placedState = ModBlocks.cuttingBoard.getStateForPlacement(world, pos, event.getFace(), 0.5f, 1.0f, 0.5f, 0, (EntityLivingBase)player, event.getHand());
            BlockEvent.PlaceEvent placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)new BlockSnapshot(world, pos, placedState), (EnumFacing)event.getFace(), (EnumHand)event.getHand());
            if (placeEvent.isCanceled()) {
                return;
            }
            world.func_175656_a(pos, placedState);
            if (!player.field_71075_bZ.field_75098_d) {
                event.getItemStack().func_190918_g(1);
            }
            player.func_184609_a(event.getHand());
            player.func_184185_a(SoundEvents.field_187891_gV, 1.0f, 1.0f);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

