/*
 * Decompiled with CFR 0.152.
 */
package cscot.basicnetherores.util.helper;

import com.google.common.base.Predicate;
import cscot.basicnetherores.util.handler.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class BlockListHelper
implements Predicate<IBlockState> {
    public static Predicate<IBlockState> PREDICATE_BLOCKS = BlockListHelper.forBlock(BlockListHelper.getBlockList(ConfigHandler.protectedBlocks));
    private final Block[] block;

    private BlockListHelper(Block ... blocks) {
        this.block = blocks;
    }

    public static BlockListHelper forBlock(Block ... blocks) {
        return new BlockListHelper(blocks);
    }

    public static BlockListHelper forBlock(List<Block> list) {
        return new BlockListHelper(list.toArray(new Block[0]));
    }

    public boolean apply(@Nullable IBlockState state) {
        for (Block block : this.block) {
            if (state == null || state.func_177230_c() != block) continue;
            return true;
        }
        return false;
    }

    public static List<Block> getBlockList(String[] array) {
        ArrayList<Block> list = new ArrayList<Block>();
        for (String name : array) {
            Block block;
            if (name == null || name.isEmpty() || (block = Block.func_149684_b((String)name)) == null) continue;
            list.add(block);
        }
        return list;
    }
}

