/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.FlyFromPointToPoint2D;
import net.machinemuse.numina.math.geometry.GradientAndArcCalculator;
import net.machinemuse.numina.math.geometry.MusePoint2D;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class ItemSelectionFrame
extends ScrollableFrame {
    protected List<ClickableItem> itemButtons;
    protected int selectedItemStack = -1;
    protected EntityPlayer player;
    protected List<MusePoint2D> itemPoints;
    protected int lastItemSlot = -1;

    public ItemSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, EntityPlayer player) {
        super(topleft, bottomright, borderColour, insideColour);
        this.player = player;
        List slots = MuseItemUtils.getModularItemSlotsInInventory((EntityPlayer)player);
        this.loadPoints(slots.size());
        this.loadItems();
    }

    public int getLastItemSlot() {
        return this.lastItemSlot;
    }

    public int getSelectedItemSlot() {
        return this.selectedItemStack;
    }

    private void loadPoints(int num) {
        double centerx = (this.border.left() + this.border.right()) / 2.0;
        double centery = (this.border.top() + this.border.bottom()) / 2.0;
        this.itemPoints = new ArrayList<MusePoint2D>();
        List targetPoints = GradientAndArcCalculator.pointsInLine((int)num, (MusePoint2D)new MusePoint2D(centerx, this.border.bottom()), (MusePoint2D)new MusePoint2D(centerx, this.border.top()));
        for (MusePoint2D point : targetPoints) {
            this.itemPoints.add((MusePoint2D)new FlyFromPointToPoint2D(new MusePoint2D(centerx, centery), point, 200.0));
        }
    }

    private void loadItems() {
        if (this.player != null) {
            this.itemButtons = new ArrayList<ClickableItem>();
            List slots = MuseItemUtils.getModularItemSlotsInInventory((EntityPlayer)this.player);
            if (slots.size() > this.itemPoints.size()) {
                this.loadPoints(slots.size());
            }
            if (slots.size() > 0) {
                Iterator<MusePoint2D> pointiterator = this.itemPoints.iterator();
                Iterator iterator = slots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    ClickableItem clickie = new ClickableItem(this.player.field_71071_by.func_70301_a(slot), pointiterator.next(), slot);
                    this.itemButtons.add(clickie);
                }
            }
        }
    }

    public void update(double mousex, double mousey) {
        this.loadItems();
    }

    public void draw() {
        this.drawBackground();
        this.drawItems();
        this.drawSelection();
    }

    private void drawBackground() {
        super.draw();
    }

    private void drawItems() {
        for (ClickableItem item : this.itemButtons) {
            item.draw();
        }
    }

    private void drawSelection() {
        if (this.selectedItemStack != -1) {
            MuseRenderer.drawCircleAround((double)Math.floor(this.itemButtons.get(this.selectedItemStack).getPosition().getX()), (double)Math.floor(this.itemButtons.get(this.selectedItemStack).getPosition().getY()), (double)10.0);
        }
    }

    public boolean hasNoItems() {
        return this.itemButtons.size() == 0;
    }

    public ClickableItem getPreviousSelectedItem() {
        if (this.itemButtons.size() > this.lastItemSlot && this.lastItemSlot != -1) {
            return this.itemButtons.get(this.lastItemSlot);
        }
        return null;
    }

    public ClickableItem getSelectedItem() {
        if (this.itemButtons.size() > this.selectedItemStack && this.selectedItemStack != -1) {
            return this.itemButtons.get(this.selectedItemStack);
        }
        return null;
    }

    public void onMouseDown(double x, double y, int button) {
        int i = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.hitBox(x, y)) {
                this.lastItemSlot = this.selectedItemStack;
                Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_SELECT, (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, null);
                this.selectedItemStack = i;
                break;
            }
            ++i;
        }
    }

    public List<String> getToolTip(int x, int y) {
        int itemHover = -1;
        int i = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.hitBox(x, y)) {
                itemHover = i;
                break;
            }
            ++i;
        }
        if (itemHover > -1) {
            return this.itemButtons.get(itemHover).getToolTip();
        }
        return null;
    }
}

