/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc;

import org.apache.commons.lang3.tuple.Pair;

public abstract class PositionalNotationPrinter<E> {
    private final int maxDigits;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public PositionalNotationPrinter(int maxDigits) {
        this.maxDigits = maxDigits;
    }

    protected abstract IDigitProvider createIntegerDigitProvider(E var1, int var2);

    protected abstract IDigitProvider createFractionalDigitProvider(E var1, int var2);

    protected abstract boolean isNegative(E var1);

    protected abstract boolean isZero(E var1);

    protected abstract E negate(E var1);

    protected abstract Pair<E, E> splitNumber(E var1);

    private static String digitToString(int digit) {
        if (digit >= digits.length) {
            return "'" + digit + "'";
        }
        return String.valueOf(digits[digit]);
    }

    public String toString(E value, int radix) {
        Pair<E, E> split;
        Object integer;
        StringBuilder result = new StringBuilder();
        boolean isNegative = this.isNegative(value);
        if (isNegative) {
            value = this.negate(value);
        }
        if ((integer = (split = this.splitNumber(value)).getLeft()) != null) {
            if (this.isZero(integer)) {
                result.append('0');
            } else {
                IDigitProvider provider = this.createIntegerDigitProvider(integer, radix);
                while (provider.hasNextDigit()) {
                    int digit = provider.getNextDigit();
                    result.insert(0, PositionalNotationPrinter.digitToString(digit));
                }
            }
        }
        if (isNegative) {
            result.insert(0, "-");
        }
        int digitCount = 0;
        Object fractional = split.getRight();
        if (fractional != null && !this.isZero(fractional)) {
            result.append('.');
            IDigitProvider provider = this.createFractionalDigitProvider(fractional, radix);
            while (provider.hasNextDigit() && digitCount++ < this.maxDigits) {
                int digit = provider.getNextDigit();
                result.append(PositionalNotationPrinter.digitToString(digit));
            }
        }
        return result.toString().replace("''", "\"");
    }

    public static interface IDigitProvider {
        public int getNextDigit();

        public boolean hasNextDigit();
    }
}

