/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.ast;

import com.google.common.collect.Maps;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IModifierStateTransition;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.utils.MiscUtils;
import java.util.List;
import java.util.Map;

public abstract class MappedParserState<N>
implements IParserState<N> {
    private final IAstParser<N> parser;
    private final Map<String, ISymbolCallStateTransition<N>> symbolTransitions = Maps.newHashMap();
    private final Map<String, IModifierStateTransition<N>> modifierTransitions = Maps.newHashMap();

    public MappedParserState(IAstParser<N> parser) {
        this.parser = parser;
    }

    @Override
    public IAstParser<N> getParser() {
        return this.parser;
    }

    @Override
    public ISymbolCallStateTransition<N> getStateForSymbolCall(String symbol) {
        ISymbolCallStateTransition<N> stateTransition = this.symbolTransitions.get(symbol);
        return stateTransition != null ? stateTransition : this.createDefaultSymbolCallStateTransition(symbol);
    }

    protected ISymbolCallStateTransition<N> createDefaultSymbolCallStateTransition(final String symbol) {
        return new ISymbolCallStateTransition<N>(){

            @Override
            public IParserState<N> getState() {
                return MappedParserState.this;
            }

            @Override
            public N createRootNode(List<N> children) {
                return MappedParserState.this.createDefaultSymbolNode(symbol, children);
            }
        };
    }

    protected abstract N createDefaultSymbolNode(String var1, List<N> var2);

    @Override
    public IModifierStateTransition<N> getStateForModifier(String modifier) {
        IModifierStateTransition<N> stateTransition = this.modifierTransitions.get(modifier);
        return stateTransition != null ? stateTransition : this.createDefaultModifierStateTransition(modifier);
    }

    protected abstract IModifierStateTransition<N> createDefaultModifierStateTransition(String var1);

    public MappedParserState<N> addStateTransition(String symbol, ISymbolCallStateTransition<N> transition) {
        MiscUtils.putOnce(this.symbolTransitions, symbol, transition);
        return this;
    }

    public MappedParserState<N> addStateTransition(String symbol, IModifierStateTransition<N> transition) {
        MiscUtils.putOnce(this.modifierTransitions, symbol, transition);
        return this;
    }
}

