/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IModifierStateTransition;
import info.openmods.calc.parsing.ast.INodeFactory;
import info.openmods.calc.parsing.ast.IOperator;
import info.openmods.calc.parsing.ast.IOperatorDictionary;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.OperatorArity;
import info.openmods.calc.parsing.ast.UnfinishedExpressionException;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.parsing.token.TokenUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PrefixParser<N, O extends IOperator<O>>
implements IAstParser<N> {
    private final IOperatorDictionary<O> operators;
    private final INodeFactory<N, O> exprNodeFactory;

    public PrefixParser(IOperatorDictionary<O> operators, INodeFactory<N, O> nodeFactory) {
        this.operators = operators;
        this.exprNodeFactory = nodeFactory;
    }

    private static Token next(Iterator<Token> input) {
        try {
            return input.next();
        }
        catch (NoSuchElementException e) {
            throw new UnfinishedExpressionException();
        }
    }

    protected N parseNode(IParserState<N> state, PeekingIterator<Token> input) {
        Token token = PrefixParser.next(input);
        return this.parseNode(state, input, token);
    }

    private N parseNode(IParserState<N> state, PeekingIterator<Token> input, Token firstToken) {
        if (firstToken.type.isValue()) {
            return this.exprNodeFactory.createValueNode(firstToken);
        }
        switch (firstToken.type) {
            case SYMBOL: {
                return this.exprNodeFactory.createSymbolGetNode(firstToken.value);
            }
            case MODIFIER: {
                return this.parseModifierNode(firstToken.value, state, input);
            }
            case LEFT_BRACKET: {
                return this.parseNestedNode(firstToken.value, state, input);
            }
        }
        throw new IllegalArgumentException("Unexpected token: " + firstToken);
    }

    private static <N> List<N> arg(N child) {
        return ImmutableList.of(child);
    }

    private static <N> List<N> args(N left, N right) {
        return ImmutableList.of(left, right);
    }

    private N parseNestedNode(String openingBracket, IParserState<N> state, PeekingIterator<Token> input) {
        String closingBracket = TokenUtils.getClosingBracket(openingBracket);
        if (openingBracket.equals("(")) {
            Token operationToken = PrefixParser.next(input);
            String operationName = operationToken.value;
            if (operationToken.type == TokenType.SYMBOL) {
                ISymbolCallStateTransition<N> stateTransition = state.getStateForSymbolCall(operationName);
                List<N> args = this.collectArgs(openingBracket, closingBracket, input, stateTransition.getState());
                return stateTransition.createRootNode(args);
            }
            if (operationToken.type == TokenType.OPERATOR) {
                List<N> args = this.collectArgs(openingBracket, closingBracket, input, state);
                if (args.size() == 1) {
                    O unaryOperator = this.operators.getOperator(operationName, OperatorArity.UNARY);
                    Preconditions.checkState((unaryOperator != null ? 1 : 0) != 0, (String)"Invalid unary operator '%s'", (Object)operationName);
                    return this.exprNodeFactory.createOpNode(unaryOperator, PrefixParser.arg(args.get(0)));
                }
                if (args.size() > 1) {
                    O binaryOperator = this.operators.getOperator(operationName, OperatorArity.BINARY);
                    Preconditions.checkState((binaryOperator != null ? 1 : 0) != 0, (String)"Invalid binary operator '%s'", (Object)operationName);
                    return this.compileBinaryOpNode(binaryOperator, args);
                }
                throw new IllegalArgumentException("Called operator " + operationName + " without any arguments");
            }
            N target = this.parseNode(state, input, operationToken);
            List<N> args = this.collectArgs(openingBracket, closingBracket, input, state);
            return this.exprNodeFactory.createOpNode(this.operators.getDefaultOperator(), PrefixParser.args(target, this.exprNodeFactory.createBracketNode(openingBracket, closingBracket, args)));
        }
        List<N> args = this.collectArgs(openingBracket, closingBracket, input, state);
        return this.exprNodeFactory.createBracketNode(openingBracket, closingBracket, args);
    }

    private List<N> collectArgs(String openingBracket, String closingBracket, PeekingIterator<Token> input, IParserState<N> state) {
        Token argToken;
        ArrayList args = Lists.newArrayList();
        while (true) {
            argToken = (Token)input.peek();
            if (argToken.type == TokenType.SEPARATOR) {
                PrefixParser.next(input);
                continue;
            }
            if (argToken.type == TokenType.RIGHT_BRACKET) break;
            IAstParser<N> newParser = state.getParser();
            N parsedNode = newParser.parse(state, input);
            args.add(parsedNode);
        }
        Preconditions.checkState((boolean)argToken.value.equals(closingBracket), (String)"Unmatched brackets: '%s' and '%s'", (Object)openingBracket, (Object)argToken.value);
        PrefixParser.next(input);
        return args;
    }

    private N parseModifierNode(String modifier, IParserState<N> state, PeekingIterator<Token> input) {
        IModifierStateTransition<N> stateTransition = state.getStateForModifier(modifier);
        IParserState<N> newState = stateTransition.getState();
        IAstParser<N> newParser = newState.getParser();
        N parsedNode = newParser.parse(newState, input);
        return stateTransition.createRootNode(parsedNode);
    }

    private N compileBinaryOpNode(O op, List<N> args) {
        boolean isLeftAssociative = op.isLowerPriority(op);
        if (isLeftAssociative) {
            N left = args.get(0);
            N right = args.get(1);
            for (int i = 2; i < args.size(); ++i) {
                left = this.exprNodeFactory.createOpNode(op, PrefixParser.args(left, right));
                right = args.get(i);
            }
            return this.exprNodeFactory.createOpNode(op, PrefixParser.args(left, right));
        }
        int lastArg = args.size() - 1;
        N left = args.get(lastArg - 1);
        N right = args.get(lastArg);
        for (int i = lastArg - 2; i >= 0; --i) {
            right = this.exprNodeFactory.createOpNode(op, PrefixParser.args(left, right));
            left = args.get(i);
        }
        return this.exprNodeFactory.createOpNode(op, PrefixParser.args(left, right));
    }

    @Override
    public N parse(IParserState<N> state, PeekingIterator<Token> input) {
        return this.parseNode(state, input);
    }
}

