/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.registry;

import com.agricraft.agricore.plant.AgriPlant;
import com.agricraft.agricore.registry.AgriLoadableRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AgriPlants
implements AgriLoadableRegistry<AgriPlant> {
    private final Map<String, AgriPlant> plants = new HashMap<String, AgriPlant>();

    public boolean hasPlant(String id) {
        return this.plants.containsKey(id);
    }

    public boolean addPlant(AgriPlant plant) {
        return this.plants.putIfAbsent(plant.getId(), plant) == null;
    }

    public AgriPlant getPlant(String id) {
        return this.plants.get(id);
    }

    public Collection<AgriPlant> getAll() {
        return Collections.unmodifiableCollection(this.plants.values());
    }

    public void validate() {
        this.plants.entrySet().removeIf(e -> !((AgriPlant)e.getValue()).validate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nPlants:");
        for (AgriPlant plant : this.plants.values()) {
            sb.append("\n\t- Plant: ");
            sb.append(plant.toString().replaceAll("\n", "\n\t").trim());
        }
        return sb.append("\n").toString();
    }

    @Override
    public boolean acceptsElement(String filename) {
        return filename.toLowerCase().endsWith("_plant.json");
    }

    @Override
    public Class<AgriPlant> getElementClass() {
        return AgriPlant.class;
    }

    @Override
    public void registerElement(AgriPlant element) {
        this.addPlant(element);
    }

    @Override
    public void clearElements() {
        this.plants.clear();
    }

    public int hashCode() {
        return this.plants.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgriPlants other = (AgriPlants)obj;
        return this.plants.equals(other.plants);
    }
}

