/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks;

import com.agricraft.agricore.util.TypeHelper;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizable;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.v1.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.items.ItemDebugger;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderCrop;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.block.BlockTileCustomRenderedBase;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IHornHarvestable;

@Optional.Interface(modid="botania", iface="vazkii.botania.api.item.IHornHarvestable")
public class BlockCrop
extends BlockTileCustomRenderedBase<TileEntityCrop>
implements IGrowable,
IPlantable,
IHornHarvestable {
    public static final AxisAlignedBB BOX = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.8125, 0.875);
    static final Class[] ITEM_EXCLUDES = new Class[]{IAgriRakeItem.class, IAgriClipperItem.class, IAgriTrowelItem.class, ItemDebugger.class};
    private static final ItemStack BONEMEAL = new ItemStack(Items.field_151100_aR, 1, 15);

    public BlockCrop() {
        super("crop", Material.field_151585_k);
        this.func_149675_a(true);
        this.field_149758_A = true;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149647_a(null);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public TileEntityCrop createNewTileEntity(World world, int meta) {
        return new TileEntityCrop();
    }

    public Optional<TileEntityCrop> getCrop(IBlockAccess world, BlockPos pos) {
        return WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityCrop.class);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            this.getCrop((IBlockAccess)world, pos).ifPresent(TileEntityCrop::onGrowthTick);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return true;
        }
        TileEntityCrop crop = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityCrop.class).orElse(null);
        if (crop == null) {
            return false;
        }
        if (heldItem.func_190926_b()) {
            crop.onHarvest(stack -> WorldHelper.spawnItemInWorld((World)world, (BlockPos)pos, (ItemStack)stack), player);
            return true;
        }
        if (TypeHelper.isAnyType(heldItem.func_77973_b(), ITEM_EXCLUDES)) {
            return false;
        }
        if (AgriApi.getFertilizerRegistry().hasAdapter(heldItem)) {
            AgriApi.getFertilizerRegistry().valueOf(heldItem).ifPresent(f -> f.applyFertilizer(player, world, pos, crop, heldItem, crop.getRandom()));
            return true;
        }
        if (heldItem.func_77973_b() == AgriItems.getInstance().CROPS && crop.onApplyCrops(player) == MethodResult.SUCCESS) {
            if (!player.func_184812_l_()) {
                heldItem.func_190920_e(heldItem.func_190916_E() - 1);
            }
            return true;
        }
        Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(heldItem);
        if (seed.isPresent() && crop.onApplySeeds(seed.get(), player) == MethodResult.SUCCESS) {
            StackHelper.decreaseStackSize(player, heldItem, 1);
            return true;
        }
        crop.onHarvest(stack -> WorldHelper.spawnItemInWorld((World)world, (BlockPos)pos, (ItemStack)stack), player);
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.getCrop((IBlockAccess)world, pos).ifPresent(crop -> crop.onBroken(stack -> WorldHelper.spawnItemInWorld((World)world, (BlockPos)pos, (ItemStack)stack), player));
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_180649_a(world, pos, player);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K) {
            this.getCrop((IBlockAccess)world, pos).ifPresent(c -> c.onBroken(stack -> WorldHelper.spawnItemInWorld((World)world, (BlockPos)pos, (ItemStack)stack), null));
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return AgriCraftConfig.allowIGrowableOnCrop && this.checkOrUseBonemeal(world, null, pos, false);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return AgriCraftConfig.allowIGrowableOnCrop && this.checkOrUseBonemeal(world, rand, pos, false);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        if (AgriCraftConfig.allowIGrowableOnCrop) {
            this.checkOrUseBonemeal(world, world.field_73012_v, pos, true);
        }
    }

    private boolean checkOrUseBonemeal(@Nonnull World world, @Nullable Random rand, @Nonnull BlockPos pos, boolean tryToApplyBonemeal) {
        Objects.requireNonNull(world, "IGrowable on BlockCrop can't function with a null world parameter.");
        Objects.requireNonNull(pos, "IGrowable on BlockCrop can't function with a null pos parameter.");
        if (tryToApplyBonemeal) {
            Objects.requireNonNull(rand, "IGrowable#grow on BlockCrop can't function with a null rand parameter.");
        }
        IAgriFertilizable crop = (IAgriFertilizable)WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, IAgriFertilizable.class).orElseThrow(() -> new RuntimeException("There is no IAgriFertilizable at: " + pos));
        IAgriFertilizer meal = AgriApi.getFertilizerRegistry().valueOf(BONEMEAL).orElseThrow(() -> new RuntimeException("Bonemeal is not registered as a fertilizer."));
        boolean canApplyBonemeal = crop.acceptsFertilizer(meal);
        if (tryToApplyBonemeal && canApplyBonemeal) {
            crop.onApplyFertilizer(meal, rand);
        }
        return canApplyBonemeal;
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
        if (!this.canBlockStay((IBlockAccess)world, pos)) {
            this.func_176226_b(world, pos, observerState, 0);
            world.func_175713_t(pos);
            world.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(IBlockAccess world, BlockPos pos) {
        return AgriApi.getSoilRegistry().contains(world.func_180495_p(pos.func_177977_b()));
    }

    public boolean isFertile(World world, BlockPos pos) {
        return this.getCrop((IBlockAccess)world, pos).map(IAgriCrop::isFertile).orElse(false);
    }

    public boolean isMature(World world, BlockPos pos) {
        return this.getCrop((IBlockAccess)world, pos).map(TileEntityCrop::isMature).orElse(false);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return AgriItems.getInstance().CROPS;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.getCrop(world, pos).ifPresent(c -> c.getDrops(drops::add, true, true, true));
        return drops;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)AgriItems.getInstance().CROPS);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOX;
    }

    @Nullable
    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return BOX.func_186670_a(pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_getBlockFaceShape_1_, IBlockState p_getBlockFaceShape_2_, BlockPos p_getBlockFaceShape_3_, EnumFacing p_getBlockFaceShape_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderCrop getRenderer() {
        return new RenderCrop(this);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getBlockModelResourceLocation() {
        return new ModelResourceLocation("agricraft".toLowerCase() + ":" + this.getInternalName());
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[0];
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public Optional<TileEntityCrop> getCropTile(IBlockAccess world, BlockPos pos) {
        return WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityCrop.class);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        Optional<TileEntityCrop> tile = this.getCropTile(world, pos);
        return ((IExtendedBlockState)state).withProperty(AgriProperties.CROP_PLANT, tile.map(TileEntityCrop::getSeed).map(s -> s.getPlant()).orElse(null)).withProperty(AgriProperties.GROWTH_STAGE, (Object)tile.map(TileEntityCrop::getGrowthStage).orElse(0)).withProperty(AgriProperties.CROSS_CROP, (Object)tile.map(TileEntityCrop::isCrossCrop).orElse(false));
    }

    public IUnlistedProperty[] getUnlistedPropertyArray() {
        return new IUnlistedProperty[]{AgriProperties.CROP_PLANT, AgriProperties.GROWTH_STAGE, AgriProperties.CROSS_CROP};
    }

    @Optional.Method(modid="botania")
    public boolean canHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType eht) {
        return eht == IHornHarvestable.EnumHornType.WILD;
    }

    @Optional.Method(modid="botania")
    public boolean hasSpecialHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType eht) {
        return eht == IHornHarvestable.EnumHornType.WILD;
    }

    @Optional.Method(modid="botania")
    public void harvestByHorn(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType eht) {
        if (eht == IHornHarvestable.EnumHornType.WILD) {
            WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityCrop.class).filter(TileEntityCrop::isMature).ifPresent(crop -> crop.onHarvest(product -> WorldHelper.spawnItemInWorld((World)world, (BlockPos)pos, (ItemStack)product), null));
        }
    }
}

