/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks;

import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.items.blocks.ItemBlockGrate;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderBlockGrate;
import com.infinityraider.agricraft.tiles.decoration.TileEntityGrate;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrate
extends BlockCustomWood<TileEntityGrate> {
    private final ItemBlockGrate itemBlock;

    public BlockGrate() {
        super("grate");
        this.field_149787_q = false;
        this.itemBlock = new ItemBlockGrate((Block)this);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[]{AgriProperties.AXIS, AgriProperties.OFFSET, AgriProperties.VINES};
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)worldIn, (BlockPos)pos, TileEntityGrate.class);
        state = AgriProperties.VINES.applyToBlockState(state, (Comparable)((Object)tile.map(TileEntityGrate::getVines).orElse(TileEntityGrate.EnumVines.NONE)));
        state = AgriProperties.OFFSET.applyToBlockState(state, (Comparable)((Object)tile.map(TileEntityGrate::getOffset).orElse(TileEntityGrate.EnumOffset.NEAR)));
        state = AgriProperties.AXIS.applyToBlockState(state, (Comparable)tile.map(TileEntityGrate::getAxis).orElse(EnumFacing.Axis.X));
        return state;
    }

    public Optional<? extends ItemBlock> getItemBlock() {
        return Optional.of(this.itemBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public RenderBlockGrate getRenderer() {
        return new RenderBlockGrate(this);
    }

    public TileEntityGrate createNewTileEntity(World world, int meta) {
        return new TileEntityGrate();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileEntityGrate)) {
            return true;
        }
        TileEntityGrate grate = (TileEntityGrate)tile;
        boolean front = grate.isPlayerInFront(player);
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (grate.removeVines(front)) {
                BlockGrate.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Blocks.field_150395_bd, 1));
                return true;
            }
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150395_bd) && grate.addVines(front) && !player.field_71075_bZ.field_75098_d) {
            stack.func_190920_e(stack.func_190916_E() - 1);
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List<ItemStack> items = super.getDrops(world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityGrate) {
            TileEntityGrate grate = (TileEntityGrate)te;
            int stackSize = 0;
            stackSize = grate.hasVines(true) ? stackSize + 1 : stackSize;
            int n = stackSize = grate.hasVines(false) ? stackSize + 1 : stackSize;
            if (stackSize > 0) {
                items.add(new ItemStack(Blocks.field_150395_bd, stackSize));
            }
        }
        return items;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return WorldHelper.getTile((IBlockAccess)worldIn, (BlockPos)pos, TileEntityGrate.class).map(t -> t.getOffset().getBounds(t.getAxis())).orElse(field_185505_j);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_180646_a(state, (IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public boolean isEnabled() {
        return AgriCraftConfig.enableGrates;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

