/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.blocks.irrigation.AbstractBlockWaterChannel;
import com.infinityraider.agricraft.blocks.irrigation.BlockWaterChannelValve;
import com.infinityraider.agricraft.renderers.blocks.RenderChannel;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWaterChannel
extends AbstractBlockWaterChannel<TileEntityChannel> {
    protected static final float MIN = 0.25f;
    protected static final float MAX = 0.75f;
    protected static final double EXPANSION = 0.015625;
    public static final AxisAlignedBB CENTER_BOX = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.3125).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.6875, 0.25, 0.25, 1.0, 0.75, 0.75).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.25, 0.25, 0.6875, 0.75, 0.75, 1.0).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.0, 0.25, 0.25, 0.3125, 0.75, 0.75).func_72321_a(0.015625, 0.015625, 0.015625);
    private final BlockWaterChannelValve.ItemBlockValve itemBlock = new BlockWaterChannelValve.ItemBlockValve((Block)this);

    public BlockWaterChannel() {
        super("normal");
    }

    public Optional<BlockWaterChannelValve.ItemBlockValve> getItemBlock() {
        return Optional.of(this.itemBlock);
    }

    public TileEntityChannel createNewTileEntity(World world, int meta) {
        return new TileEntityChannel();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, @Nullable Entity entity, boolean isActualState) {
        BlockWaterChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)CENTER_BOX);
        TileEntityChannel tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannel.class).orElse(null);
        if (tile == null) {
            return;
        }
        if (tile.getConnections().get(EnumFacing.NORTH) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)NORTH_BOX);
        }
        if (tile.getConnections().get(EnumFacing.EAST) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)EAST_BOX);
        }
        if (tile.getConnections().get(EnumFacing.SOUTH) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)SOUTH_BOX);
        }
        if (tile.getConnections().get(EnumFacing.WEST) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)WEST_BOX);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityChannel tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannel.class).orElse(null);
        AxisAlignedBB selection = CENTER_BOX;
        if (tile != null) {
            if (tile.getConnections().get(EnumFacing.NORTH) > 0) {
                selection = selection.func_111270_a(NORTH_BOX);
            }
            if (tile.getConnections().get(EnumFacing.EAST) > 0) {
                selection = selection.func_111270_a(EAST_BOX);
            }
            if (tile.getConnections().get(EnumFacing.SOUTH) > 0) {
                selection = selection.func_111270_a(SOUTH_BOX);
            }
            if (tile.getConnections().get(EnumFacing.WEST) > 0) {
                selection = selection.func_111270_a(WEST_BOX);
            }
        }
        return selection;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderChannel getRenderer() {
        return new RenderChannel<BlockWaterChannel, TileEntityChannel>(this, this.createNewTileEntity(null, 0));
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

