/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.BlockSeedAnalyzer;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.models.ModelSeedAnalyzer;
import com.infinityraider.agricraft.renderers.models.ModelSeedAnalyzerBook;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.utility.IconHelper;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.render.block.RenderBlockWithTileBase;
import com.infinityraider.infinitylib.render.model.ModelTechne;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSeedAnalyzer
extends RenderBlockWithTileBase<BlockSeedAnalyzer, TileEntitySeedAnalyzer> {
    public static ResourceLocation TEXTURE_ANALYZER = new ResourceLocation("agricraft".toLowerCase() + ":blocks/seed_analyzer");
    private static final ModelTechne<ModelSeedAnalyzer> MODEL_ANALYZER = new ModelTechne((ModelBase)new ModelSeedAnalyzer()).setDiffuseLighting(false);
    private static final ModelTechne<ModelSeedAnalyzerBook> MODEL_BOOK = new ModelTechne((ModelBase)new ModelSeedAnalyzerBook()).setDiffuseLighting(false);
    private List<BakedQuad> analyzerQuads;
    private List<BakedQuad> bookQuads;

    public RenderSeedAnalyzer(BlockSeedAnalyzer block) {
        super((BlockBase)block, (TileEntityBase)new TileEntitySeedAnalyzer(), true, true, true);
    }

    private void renderModel(ITessellator tessellator, EnumFacing direction, boolean journal) {
        tessellator.pushMatrix();
        RenderSeedAnalyzer.rotateBlock((ITessellator)tessellator, (EnumFacing)direction);
        if (this.analyzerQuads == null) {
            this.analyzerQuads = MODEL_ANALYZER.getBakedQuads(tessellator.getVertexFormat(), RenderSeedAnalyzer.getIcon((ResourceLocation)TEXTURE_ANALYZER));
        }
        tessellator.addQuads(this.analyzerQuads);
        if (journal) {
            if (this.bookQuads == null) {
                this.bookQuads = MODEL_BOOK.getBakedQuads(tessellator.getVertexFormat(), RenderSeedAnalyzer.getIcon((ResourceLocation)TEXTURE_ANALYZER));
            }
            tessellator.addQuads(this.bookQuads);
        }
        tessellator.popMatrix();
    }

    private void renderSeed(TileEntitySeedAnalyzer te, double x, double y, double z) {
        if (te != null && te.hasSpecimen()) {
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179101_C();
            RenderSeedAnalyzer.renderItemStack((ItemStack)te.getSpecimen(), (double)0.5, (double)0.5, (double)0.5, (double)0.75, (boolean)true);
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
        }
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        textures.add(TEXTURE_ANALYZER);
        return textures;
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, BlockSeedAnalyzer block, EnumFacing side) {
        this.renderModel(tessellator, (EnumFacing)AgriProperties.FACING.getValue(state), (Boolean)AgriProperties.JOURNAL.getValue(state));
    }

    public void renderWorldBlockDynamic(ITessellator tessellator, World world, BlockPos pos, double x, double y, double z, BlockSeedAnalyzer block, TileEntitySeedAnalyzer tile, float partialTick, int destroyStage, float alpha) {
        tessellator.draw();
        this.renderSeed(tile, 0.0, 0.0, 0.0);
        tessellator.startDrawingQuads(DefaultVertexFormats.field_176600_a);
    }

    public void renderInventoryBlock(ITessellator tessellator, World world, IBlockState state, BlockSeedAnalyzer block, TileEntitySeedAnalyzer tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
        this.renderModel(tessellator, EnumFacing.NORTH, true);
    }

    public TextureAtlasSprite getIcon() {
        return IconHelper.getIcon(TEXTURE_ANALYZER.toString());
    }

    public boolean applyAmbientOcclusion() {
        return false;
    }
}

