/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.storage;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageControllable;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageController;
import com.infinityraider.agricraft.tiles.storage.SeedStorageSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TileEntitySeedStorageController
extends TileEntityCustomWood
implements ISeedStorageController {
    private final List<ISeedStorageControllable> controllables = new ArrayList<ISeedStorageControllable>();
    public boolean isControlling;

    @Override
    public boolean addStackToInventory(ItemStack stack) {
        return this.getControllable(stack).map(c -> c.addStackToInventory(stack)).orElse(false);
    }

    @Override
    public List<ItemStack> getControlledSeeds() {
        return this.controllables.stream().map(c -> c.getLockedSeed()).filter(s -> s.isPresent()).map(c -> ((AgriSeed)c.get()).toStack()).collect(Collectors.toList());
    }

    @Override
    public List<SeedStorageSlot> getSlots(Item seed, int meta) {
        return this.getControllable(new ItemStack(seed, 1, meta)).map(c -> c.getSeedSlots()).orElse(Collections.EMPTY_LIST);
    }

    @Override
    public void addControllable(ISeedStorageControllable controllable) {
        if (!controllable.hasController()) {
            this.controllables.add(controllable);
        }
    }

    @Override
    public boolean isControlling() {
        return this.isControlling;
    }

    public ArrayList<int[]> getControlledCoordinates() {
        ArrayList<int[]> coords = new ArrayList<int[]>();
        for (ISeedStorageControllable controllable : this.controllables) {
            coords.add(controllable.getCoords());
        }
        return coords;
    }

    @Override
    public int[] getCoordinates() {
        return new int[]{this.xCoord(), this.yCoord(), this.zCoord()};
    }

    @Override
    public int getControllableID(ISeedStorageControllable controllable) {
        int id = -1;
        for (int i = 0; i < this.controllables.size() && id < 0; ++i) {
            ISeedStorageControllable currentControllable = this.controllables.get(i);
            if (currentControllable != controllable) continue;
            id = i;
        }
        return id;
    }

    @Override
    public Optional<ISeedStorageControllable> getControllable(ItemStack stack) {
        IAgriPlant plant = AgriApi.getSeedRegistry().valueOf(stack).map(s -> s.getPlant()).orElse(null);
        if (plant == null) {
            return Optional.empty();
        }
        return this.controllables.stream().filter(c -> c.getLockedSeed().filter(s -> s.getPlant() == plant).isPresent()).findAny();
    }
}

