/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.skull;

import com.enderio.core.client.render.ManagedTESR;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.block.skull.TileEndermanSkull;
import crazypants.enderio.base.init.ModObject;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EndermanSkullRenderer
extends ManagedTESR<TileEndermanSkull> {
    public EndermanSkullRenderer() {
        super(ModObject.blockEndermanSkull.getBlock());
    }

    protected void renderTileEntity(@Nonnull TileEndermanSkull te, @Nonnull IBlockState blockState, float partialTicks, int destroyStage) {
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        GlStateManager.func_179114_b((float)this.getYaw(te, partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        RenderUtil.renderBlockModel((World)te.func_145831_w(), (BlockPos)te.func_174877_v(), (boolean)true);
    }

    float getYaw(TileEndermanSkull te, float partialTicks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double d = te.func_174877_v().func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        double speed = d < 9.0 ? 2.5 : (d < 36.0 ? 1.5 : 0.5);
        float partialYaw = (float)(speed * (double)partialTicks);
        Angle yaw = new Angle(360.0, te.getYaw());
        if (d < 100.0) {
            double d0 = player.field_70165_t - (double)((float)te.func_174877_v().func_177958_n() + 0.5f);
            double d1 = player.field_70161_v - (double)((float)te.func_174877_v().func_177952_p() + 0.5f);
            Angle target = new Angle(360.0, MathHelper.func_181159_b((double)d1, (double)d0) * 180.0 / Math.PI + 90.0);
            Angle diff = new Angle(180.0, yaw.get() - target.get());
            if (diff.get() > 1.0 || diff.get() < -1.0) {
                if (diff.get() > 0.0) {
                    yaw.add(-Math.min(diff.get(), speed));
                } else {
                    yaw.add(Math.min(-diff.get(), speed));
                    partialYaw = -partialYaw;
                }
            } else {
                partialYaw = 0.0f;
            }
        } else {
            yaw.add(1.0);
            partialYaw = partialTicks;
        }
        if (te.lastTick != EnderIO.proxy.getTickCount()) {
            te.lastTick = EnderIO.proxy.getTickCount();
            if (te.lookingAt > 0) {
                --te.lookingAt;
            }
            te.setYaw((float)yaw.get());
        }
        float ret = -te.getYaw() + partialYaw;
        if (te.lookingAt > 0) {
            float intensity = Math.min(3.0f, (float)te.lookingAt / 3.0f);
            ret += ((te.lastTick & 1L) == 0L ? intensity : -intensity) * (partialTicks * 2.0f);
        }
        return ret;
    }

    private static class Angle {
        private final double offset;
        private double a;

        Angle(double offset, double a) {
            this.offset = offset;
            this.set(a);
        }

        void set(double a) {
            while (a >= this.offset) {
                a -= 360.0;
            }
            while (a < this.offset - 360.0) {
                a += 360.0;
            }
            this.a = a;
        }

        void add(double b) {
            this.set(this.a + b);
        }

        double get() {
            return this.a;
        }
    }
}

