/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDarkSteelSFX
implements IMessage {
    private ResourceLocation upgradeName;
    private UUID uid;

    public PacketDarkSteelSFX() {
    }

    public PacketDarkSteelSFX(@Nonnull IDarkSteelUpgrade upgrade, @Nonnull EntityPlayer player) {
        this.upgradeName = upgrade.getRegistryName();
        this.uid = player.func_110124_au();
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.upgradeName.toString());
        buffer.writeLong(this.uid.getLeastSignificantBits());
        buffer.writeLong(this.uid.getMostSignificantBits());
    }

    public void fromBytes(ByteBuf buffer) {
        String string = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.upgradeName = string != null ? new ResourceLocation(string) : null;
        long leastSig = buffer.readLong();
        long mostSig = buffer.readLong();
        this.uid = new UUID(mostSig, leastSig);
    }

    public static class ClientHandler
    implements IMessageHandler<PacketDarkSteelSFX, IMessage> {
        public IMessage onMessage(PacketDarkSteelSFX message, MessageContext ctx) {
            EntityPlayer otherPlayer;
            IDarkSteelUpgrade upgrade;
            UUID uid = message.uid;
            if (message.upgradeName != null && uid != null && (upgrade = UpgradeRegistry.getUpgrade(message.upgradeName)) != null && (otherPlayer = EnderIO.proxy.getClientWorld().func_152378_a(uid)) != null) {
                upgrade.doMultiplayerSFX(otherPlayer);
            }
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketDarkSteelSFX, IMessage> {
        public IMessage onMessage(PacketDarkSteelSFX message, MessageContext ctx) {
            IDarkSteelUpgrade upgrade;
            if (message.upgradeName != null && (upgrade = UpgradeRegistry.getUpgrade(message.upgradeName)) != null) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                message.uid = player.func_110124_au();
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    ItemStack stack;
                    if (slot == null || !upgrade.hasUpgrade(stack = player.func_184582_a(slot))) continue;
                    WorldServer worldServer = (WorldServer)player.field_70170_p;
                    PlayerChunkMap playerManager = worldServer.func_184164_w();
                    int chunkX = (int)player.field_70165_t >> 4;
                    int chunkZ = (int)player.field_70161_v >> 4;
                    for (Object playerObj : worldServer.field_73010_i) {
                        EntityPlayerMP otherPlayer;
                        if (!(playerObj instanceof EntityPlayerMP) || playerObj == player || !playerManager.func_72694_a(otherPlayer = (EntityPlayerMP)playerObj, chunkX, chunkZ)) continue;
                        PacketHandler.INSTANCE.sendTo((IMessage)message, otherPlayer);
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

