/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vacuum.chest;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.inventory.Callback;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.MagnetUtil;
import com.enderio.core.common.vecmath.Vector4f;
import com.google.common.base.Predicate;
import crazypants.enderio.base.autosave.enderio.HandleIFilter;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.ITileFilterContainer;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.items.IItemFilterItemUpgrade;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.interfaces.IHasFillLevel;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.config.config.VacuumConfig;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

@Storable
public class TileVacuumChest
extends AbstractCapabilityMachineEntity
implements IRedstoneModeControlable,
IPaintable.IPaintableTileEntity,
IRanged,
ITileFilterContainer,
IHasFillLevel {
    private static Filters.PredicateItemStack PREDICATE_FILTER = new Filters.PredicateItemStack(){

        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77973_b() instanceof IItemFilterItemUpgrade;
        }
    };
    private Callback<ItemStack> CALLBACK_FILTER = new Callback<ItemStack>(){

        public void onChange(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
            if (TileVacuumChest.this.filter != null) {
                FilterRegistry.writeFilterToStack(TileVacuumChest.this.filter, oldStack);
            }
            TileVacuumChest.this.filter = (IItemFilter)FilterRegistry.getFilterForUpgrade(newStack);
            TileVacuumChest.this.forceUpdatePlayers();
        }
    };
    public static final int ITEM_ROWS = 3;
    public static final int ITEM_COLS = 9;
    public static final int ITEM_SLOTS = 27;
    public static final int FILTER_SLOTS = 5;
    @Store
    private int range = (Integer)VacuumConfig.vacuumChestRange.get();
    @Store(handler=HandleIFilter.class)
    private IItemFilter filter;
    @Store(value={NBTAction.CLIENT})
    private boolean clientActive;
    private boolean showingRange;
    private static final Vector4f color = new Vector4f(0.11f, 0.11f, 0.94f, 0.4f);

    public TileVacuumChest() {
        for (int i = 0; i < 27; ++i) {
            this.getInventory().add(EnderInventory.Type.INOUT, "slot" + i, new InventorySlot());
        }
        this.getInventory().add(EnderInventory.Type.UPGRADE, "filter", new InventorySlot((Predicate)PREDICATE_FILTER, null, this.CALLBACK_FILTER, 1));
        this.redstoneControlMode = RedstoneControlMode.IGNORE;
    }

    @Override
    public boolean isActive() {
        boolean active;
        if (this.field_145850_b.field_72995_K) {
            return this.clientActive;
        }
        boolean bl = active = this.redstoneCheckPassed && !this.isFull();
        if (active != this.clientActive) {
            this.clientActive = active;
            this.func_70296_d();
        }
        return active;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (this.isActive()) {
            this.doHoover();
        }
        return false;
    }

    @Override
    protected void updateEntityClient() {
        YetaUtil.refresh((TileEntity)this);
        if (this.isActive()) {
            this.doHoover();
        }
    }

    private List<EntityItem> selectEntitiesWithinAABB(World worldIn, AxisAlignedBB bb) {
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        int maxItems = (Integer)VacuumConfig.vacuumChestMaxItems.get();
        int minChunkX = MathHelper.func_76128_c((double)(bb.field_72340_a / 16.0));
        int maxChunkX = MathHelper.func_76128_c((double)(bb.field_72336_d / 16.0));
        int minChunkZ = MathHelper.func_76128_c((double)(bb.field_72339_c / 16.0));
        int maxChunkZ = MathHelper.func_76128_c((double)(bb.field_72334_f / 16.0));
        int minChunkY = MathHelper.func_76128_c((double)(bb.field_72338_b / 16.0));
        int maxChunkY = MathHelper.func_76128_c((double)(bb.field_72337_e / 16.0));
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                Chunk chunk = worldIn.func_72964_e(chunkX, chunkZ);
                ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
                int minChunkYClamped = MathHelper.func_76125_a((int)minChunkY, (int)0, (int)(entityLists.length - 1));
                int maxChunkYClamped = MathHelper.func_76125_a((int)maxChunkY, (int)0, (int)(entityLists.length - 1));
                for (int chunkY = minChunkYClamped; chunkY <= maxChunkYClamped; ++chunkY) {
                    for (Entity entity : entityLists[chunkY]) {
                        if (entity.field_70128_L || !(entity instanceof EntityItem) || !entity.func_174813_aQ().func_72326_a(bb) || this.filter != null && !this.filter.doesItemPassFilter(null, ((EntityItem)entity).func_92059_d()) || !MagnetUtil.shouldAttract((BlockPos)this.func_174877_v(), (Entity)entity, (boolean)true)) continue;
                        result.add((EntityItem)entity);
                        if (maxItems <= 0 || maxItems > result.size()) continue;
                        return result;
                    }
                }
            }
        }
        return result;
    }

    private void doHoover() {
        int rangeSqr = this.range * this.range;
        for (EntityItem entity : this.selectEntitiesWithinAABB(this.func_145831_w(), (AxisAlignedBB)this.getBounds())) {
            double z;
            double y;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u) * y + (z = (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v) * z);
            if (distance < 1.25 || this.range == 0) {
                this.hooverEntity((Entity)entity);
                continue;
            }
            double speed = 0.06;
            double distScale = 1.0 - Math.min(0.9, (distance - 1.0) / (double)rangeSqr);
            distScale *= distScale;
            entity.field_70159_w += x / distance * distScale * speed;
            entity.field_70181_x += y / distance * distScale * 0.4;
            entity.field_70179_y += z / distance * distScale * speed;
        }
    }

    private void hooverEntity(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d().func_77946_l();
            int numInserted = ItemTools.doInsertItem((IItemHandler)this.getInventory().getView(EnderInventory.Type.INPUT), stack);
            stack.func_190918_g(numInserted);
            item.func_92058_a(stack);
            if (Prep.isInvalid(stack)) {
                item.func_70106_y();
            }
        }
    }

    private boolean isFull() {
        for (InventorySlot slot : this.getInventory().getView(EnderInventory.Type.INPUT)) {
            ItemStack stackInSlot = slot.getStackInSlot(0);
            if (!Prep.isInvalid(stackInSlot) && stackInSlot.func_190916_E() >= stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private int limitRange(int rangeIn) {
        return Math.max(0, Math.min((Integer)VacuumConfig.vacuumChestRange.get(), rangeIn));
    }

    public void setRange(int range) {
        this.range = this.limitRange(range);
        this.func_70296_d();
    }

    public boolean hasItemFilter() {
        return this.filter != null;
    }

    public IItemFilter getItemFilter() {
        return this.filter;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileVacuumChest>(this, color));
        }
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        return new BoundingBox(this.func_174877_v()).expand((double)(this.getRange() + (this.range == 0 ? 0.03125f : 0.0f)));
    }

    public float getRange() {
        return this.range;
    }

    @Override
    public void setFilter(int filterIndex, int param, @Nonnull IFilter filter) {
        this.filter = (IItemFilter)filter;
    }

    @Override
    public IFilter getFilter(int filterIndex, int param1) {
        return this.filter;
    }

    @Override
    @Nullable
    public IItemHandler getInventoryForSnapshot(int filterIndex, int param1) {
        return this.getInventory();
    }
}

