/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import openblocks.common.TrophyHandler;
import openblocks.common.item.ItemTrophyBlock;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomHarvestDrops;
import openmods.api.ICustomPickItem;
import openmods.api.IPlaceAwareTile;
import openmods.sync.SyncableEnum;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.ItemUtils;

public class TileEntityTrophy
extends SyncedTileEntity
implements IPlaceAwareTile,
IActivateAwareTile,
ICustomHarvestDrops,
ICustomPickItem,
ITickable {
    private final String TAG_COOLDOWN = "cooldown";
    private int cooldown = 0;
    private SyncableEnum<TrophyHandler.Trophy> trophyIndex;

    protected void createSyncedFields() {
        this.trophyIndex = new SyncableEnum((Enum)TrophyHandler.Trophy.PigZombie);
    }

    public TrophyHandler.Trophy getTrophy() {
        return (TrophyHandler.Trophy)this.trophyIndex.get();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TrophyHandler.Trophy trophy = this.getTrophy();
            if (trophy != null) {
                trophy.executeTickBehavior(this);
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TrophyHandler.Trophy trophyType;
        if (!this.field_145850_b.field_72995_K && hand == EnumHand.MAIN_HAND && (trophyType = this.getTrophy()) != null) {
            trophyType.playSound(this.field_145850_b, this.field_174879_c);
            if (this.cooldown <= 0) {
                this.cooldown = trophyType.executeActivateBehavior(this, player);
            }
        }
        return true;
    }

    public void onBlockPlacedBy(IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        TrophyHandler.Trophy trophy = ItemTrophyBlock.getTrophy(stack);
        if (trophy != null) {
            this.trophyIndex.set((Enum)trophy);
        }
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            this.cooldown = tag.func_74762_e("cooldown");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.cooldown = tag.func_74762_e("cooldown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        return tag;
    }

    public boolean suppressBlockHarvestDrops() {
        return true;
    }

    @Nonnull
    private ItemStack getAsItem() {
        ItemStack stack;
        TrophyHandler.Trophy trophy = this.getTrophy();
        if (trophy != null && !(stack = trophy.getItemStack()).func_190926_b()) {
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74768_a("cooldown", this.cooldown);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops, IBlockState blockState, int fortune, boolean isSilkTouch) {
        ItemStack stack = this.getAsItem();
        if (!stack.func_190926_b()) {
            drops.add(stack);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(EntityPlayer player) {
        TrophyHandler.Trophy trophy = this.getTrophy();
        return trophy != null ? trophy.getItemStack() : ItemStack.field_190927_a;
    }
}

