/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.client.render;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunk;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunkClient;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MobileChunkRenderer {
    public boolean needsUpdate;
    public boolean isRemoved;
    public LegacyRender legacyRender = new LegacyRender();
    public VBORender vboRender = new VBORender();
    private boolean usingVBOs = this.useVBO();
    private MobileChunkClient chunk;

    public MobileChunkRenderer(MobileChunk mobilechunk) {
        this.chunk = (MobileChunkClient)mobilechunk;
        this.needsUpdate = true;
    }

    public boolean useVBO() {
        return OpenGlHelper.func_176075_f() && !FMLClientHandler.instance().hasOptifine();
    }

    public void render(float partialTicks) {
        try {
            if (this.usingVBOs != this.useVBO()) {
                this.usingVBOs = this.useVBO();
                if (this.usingVBOs) {
                    this.legacyRender.remove();
                } else {
                    this.vboRender.remove();
                }
                this.needsUpdate = true;
            }
            if (this.isRemoved) {
                this.vboRender.remove();
                this.legacyRender.remove();
                return;
            }
            if (this.needsUpdate) {
                this.vboRender.compile();
                this.legacyRender.compile();
                this.needsUpdate = false;
            }
            if (this.usingVBOs) {
                this.vboRender.render();
            } else {
                this.legacyRender.render();
            }
            this.renderTiles(partialTicks);
        }
        catch (Exception e) {
            MovingWorldMod.LOG.error("Exception when rendering a MobileChunk! {}", (Throwable)e);
        }
    }

    private void renderTiles(float partialTicks) {
        TileEntitySpecialRenderer renderer;
        TileEntity tile;
        GlStateManager.func_179094_E();
        TileEntityRendererDispatcher dispatcher = TileEntityRendererDispatcher.field_147556_a;
        World tesrDispatchWorld = dispatcher.field_147550_f;
        dispatcher.func_147543_a((World)this.chunk.getFakeWorld());
        for (Map.Entry<BlockPos, TileEntity> blockPosTileEntityEntry : this.chunk.normalTESRS.entrySet()) {
            tile = blockPosTileEntityEntry.getValue();
            tile.func_145834_a((World)this.chunk.getFakeWorld());
            renderer = dispatcher.func_147547_b(tile);
            if (renderer != null && tile.shouldRenderInPass(MinecraftForgeClient.getRenderPass())) {
                dispatcher.func_147549_a(tile, (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), partialTicks);
            }
            tile.func_145834_a(this.chunk.world);
        }
        dispatcher.func_147543_a(tesrDispatchWorld);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        dispatcher.preDrawBatch();
        for (Map.Entry<BlockPos, TileEntity> blockPosTileEntityEntry : this.chunk.fastTESRS.entrySet()) {
            tile = blockPosTileEntityEntry.getValue();
            tile.func_145834_a((World)this.chunk.getFakeWorld());
            renderer = dispatcher.func_147547_b(tile);
            if (renderer != null && tile.shouldRenderInPass(MinecraftForgeClient.getRenderPass())) {
                dispatcher.func_147549_a(tile, (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), partialTicks);
            }
            tile.func_145834_a(this.chunk.world);
        }
        dispatcher.drawBatch(0);
        GlStateManager.func_179121_F();
    }

    public void dispatchBlockRender(BlockPos blockPos, IBlockState blockState, BufferBuilder buffer) {
        buffer.func_181666_a(1.0f, 1.0f, 1.0f, 1.0f);
        BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        blockRendererDispatcher.func_175018_a(blockState, blockPos, (IBlockAccess)this.chunk.getFakeWorld(), buffer);
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    public void markRemoved() {
        this.isRemoved = true;
    }

    public class VBORender {
        private final VertexBuffer[] vertexBuffers = new VertexBuffer[BlockRenderLayer.values().length];

        public void compile() {
            this.remove();
            HashMap blockRenderMap = Maps.newHashMap();
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                blockRenderMap.put(blockRenderLayer, new ArrayList());
            }
            for (int y = MobileChunkRenderer.this.chunk.minY(); y < MobileChunkRenderer.this.chunk.maxY(); ++y) {
                for (int z = MobileChunkRenderer.this.chunk.minZ(); z < MobileChunkRenderer.this.chunk.maxZ(); ++z) {
                    for (int x = MobileChunkRenderer.this.chunk.minX(); x < MobileChunkRenderer.this.chunk.maxX(); ++x) {
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState blockState = MobileChunkRenderer.this.chunk.func_180495_p(pos);
                        Block block = blockState.func_177230_c();
                        for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                            if (!block.canRenderInLayer(blockState, blockRenderLayer) || blockState.func_185901_i().equals((Object)EnumBlockRenderType.INVISIBLE)) continue;
                            ((List)blockRenderMap.get(blockRenderLayer)).add(new Tuple((Object)pos, (Object)blockState));
                        }
                    }
                }
            }
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                BlockRenderLayer renderLayer = BlockRenderLayer.values()[i];
                this.vertexBuffers[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                List data = (List)blockRenderMap.get(renderLayer);
                BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
                BlockRendererDispatcher blockDispatcher = Minecraft.func_71410_x().func_175602_ab();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                for (Tuple datum : data) {
                    bufferBuilder.func_181666_a(1.0f, 1.0f, 1.0f, 1.0f);
                    blockDispatcher.func_175018_a((IBlockState)datum.func_76340_b(), (BlockPos)datum.func_76341_a(), (IBlockAccess)MobileChunkRenderer.this.chunk.getFakeWorld(), bufferBuilder);
                }
                bufferBuilder.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
                bufferBuilder.func_178977_d();
                this.vertexBuffers[i].func_181722_a(bufferBuilder.func_178966_f());
                bufferBuilder.func_178965_a();
            }
        }

        private void renderLayer(BlockRenderLayer layer) {
            VertexBuffer vbo = this.vertexBuffers[layer.ordinal()];
            if (vbo == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_187410_q((int)32884);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_187410_q((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187410_q((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_187410_q((int)32886);
            GlStateManager.func_179094_E();
            vbo.func_177359_a();
            this.setupArrayPointers();
            vbo.func_177358_a(7);
            GlStateManager.func_179121_F();
            OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
            GlStateManager.func_179117_G();
            for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
                VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
                int i = vertexformatelement.func_177369_e();
                switch (vertexformatelement$enumusage) {
                    case POSITION: {
                        GlStateManager.func_187429_p((int)32884);
                        break;
                    }
                    case UV: {
                        OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + i));
                        GlStateManager.func_187429_p((int)32888);
                        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                        break;
                    }
                    case COLOR: {
                        GlStateManager.func_187429_p((int)32886);
                        GlStateManager.func_179117_G();
                    }
                }
            }
            GlStateManager.func_179121_F();
        }

        private void setupArrayPointers() {
            GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
            GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }

        public void remove() {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                if (this.vertexBuffers[i] == null) continue;
                this.vertexBuffers[i].func_177362_c();
            }
        }

        public void render() {
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            GlStateManager.func_179089_o();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                this.renderLayer(BlockRenderLayer.values()[i]);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179129_p();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }
    }

    public class LegacyRender {
        private int displayList = -1;

        public void compile() {
            this.displayList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.displayList, (int)4864);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            GlStateManager.func_179089_o();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            HashMap blockRenderMap = Maps.newHashMap();
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                blockRenderMap.put(blockRenderLayer, new ArrayList());
            }
            for (int y = MobileChunkRenderer.this.chunk.minY(); y < MobileChunkRenderer.this.chunk.maxY(); ++y) {
                for (int z = MobileChunkRenderer.this.chunk.minZ(); z < MobileChunkRenderer.this.chunk.maxZ(); ++z) {
                    for (int x = MobileChunkRenderer.this.chunk.minX(); x < MobileChunkRenderer.this.chunk.maxX(); ++x) {
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState blockState = MobileChunkRenderer.this.chunk.func_180495_p(pos);
                        Block block = blockState.func_177230_c();
                        for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                            if (!block.canRenderInLayer(blockState, blockRenderLayer) || blockState.func_185901_i().equals((Object)EnumBlockRenderType.INVISIBLE)) continue;
                            ((List)blockRenderMap.get(blockRenderLayer)).add(new Tuple((Object)pos, (Object)blockState));
                        }
                    }
                }
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                for (Tuple blockRenderData : (List)blockRenderMap.get(blockRenderLayer)) {
                    MobileChunkRenderer.this.dispatchBlockRender((BlockPos)blockRenderData.func_76341_a(), (IBlockState)blockRenderData.func_76340_b(), buffer);
                }
            }
            buffer.func_178969_c(0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179129_p();
            RenderHelper.func_74519_b();
            GlStateManager.func_187415_K();
        }

        public void remove() {
            if (this.displayList >= 0) {
                GlStateManager.func_187449_e((int)this.displayList, (int)1);
            }
        }

        public void render() {
            if (this.displayList >= 0) {
                GlStateManager.func_179148_o((int)this.displayList);
            }
        }
    }
}

