/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.chunk;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunk;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public abstract class ChunkIO {
    public static void write(DataOutput out, MobileChunk chunk, Collection<BlockPos> blocks) throws IOException {
        out.writeShort(blocks.size());
        for (BlockPos p : blocks) {
            ChunkIO.writeBlock(out, chunk, p);
        }
    }

    public static int writeAll(DataOutput out, MobileChunk chunk) throws IOException {
        IBlockState state;
        int k;
        int j;
        int i;
        int count = 0;
        for (i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    state = chunk.func_180495_p(new BlockPos(i, j, k));
                    if (state == null || state.func_177230_c() == Blocks.field_150350_a) continue;
                    ++count;
                }
            }
        }
        MovingWorldMod.LOG.debug("Writing mobile chunk data: " + count + " blocks");
        out.writeShort(count);
        for (i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    state = chunk.func_180495_p(new BlockPos(i, j, k));
                    if (state == null || state.func_177230_c() == Blocks.field_150350_a) continue;
                    ChunkIO.writeBlock(out, chunk.func_180495_p(new BlockPos(i, j, k)), new BlockPos(i, j, k));
                }
            }
        }
        return count;
    }

    public static void writeBlock(DataOutput out, MobileChunk chunk, BlockPos pos) throws IOException {
        ChunkIO.writeBlock(out, chunk.func_180495_p(pos), pos);
    }

    public static void writeBlock(DataOutput out, IBlockState state, BlockPos pos) throws IOException {
        out.writeByte(pos.func_177958_n());
        out.writeByte(pos.func_177956_o());
        out.writeByte(pos.func_177952_p());
        out.writeShort(Block.func_149682_b((Block)state.func_177230_c()));
        out.writeInt(state.func_177230_c().func_176201_c(state));
    }

    public static void read(DataInput in, MobileChunk chunk) throws IOException {
        int count = in.readShort();
        MovingWorldMod.LOG.debug("Reading mobile chunk data: " + count + " blocks");
        for (int i = 0; i < count; ++i) {
            byte x = in.readByte();
            byte y = in.readByte();
            byte z = in.readByte();
            short id = in.readShort();
            IBlockState state = Block.func_149729_e((int)id).func_176203_a(in.readInt());
            chunk.setBlockState(new BlockPos((int)x, (int)y, (int)z), state);
        }
    }

    public static ByteBuf writeCompressed(MobileChunk chunk, Collection<BlockPos> blocks) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            ChunkIO.writeCompressed(buffer, chunk, blocks);
        }
        catch (IOException e) {
            MovingWorldMod.LOG.error((Object)e);
        }
        return buffer;
    }

    public static void writeCompressed(ByteBuf buf, MobileChunk chunk, Collection<BlockPos> blocks) throws IOException {
        DataOutputStream out = ChunkIO.preCompress(buf);
        ChunkIO.write(out, chunk, blocks);
        ChunkIO.postCompress(buf, out, blocks.size());
    }

    public static void writeAllCompressed(ByteBuf buf, MobileChunk chunk) throws IOException {
        DataOutputStream out = ChunkIO.preCompress(buf);
        int count = ChunkIO.writeAll(out, chunk);
        ChunkIO.postCompress(buf, out, count);
    }

    private static DataOutputStream preCompress(ByteBuf data) throws IOException {
        ByteBufOutputStream bbos = new ByteBufOutputStream(data);
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream((OutputStream)bbos));
        return out;
    }

    private static void postCompress(ByteBuf data, DataOutputStream out, int count) throws IOException {
        out.flush();
        out.close();
        int byteswritten = data.writerIndex();
        float f = (float)byteswritten / (float)(count * 9);
        MovingWorldMod.LOG.debug(String.format(Locale.ENGLISH, "%d blocks written. Efficiency: %d/%d = %.2f", count, byteswritten, count * 9, Float.valueOf(f)));
        if (byteswritten > 32000) {
            MovingWorldMod.LOG.warn("MobileChunk probably contains too many blocks");
        }
    }

    public static void readCompressed(ByteBuf data, MobileChunk chunk) throws IOException {
        DataInputStream in = new DataInputStream(new GZIPInputStream((InputStream)new ByteBufInputStream(data)));
        ChunkIO.read(in, chunk);
        in.close();
    }
}

