/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.entity;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.chunk.ChunkIO;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunkServer;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.entity.MovingWorldHandlerCommon;
import com.elytradev.movingworld.common.network.message.MovingWorldBlockChangeMessage;
import com.elytradev.movingworld.common.network.message.MovingWorldTileChangeMessage;
import com.elytradev.movingworld.common.tile.TileMovingMarkingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public abstract class MovingWorldHandlerServer
extends MovingWorldHandlerCommon {
    protected boolean firstChunkUpdate = true;

    public MovingWorldHandlerServer(EntityMovingWorld entitymovingWorld) {
        super(entitymovingWorld);
    }

    @Override
    public boolean processInitialInteract(EntityPlayer player, EnumHand hand) {
        return false;
    }

    private MobileChunkServer getMobileChunkServer() {
        if (this.getMovingWorld() != null && this.getMovingWorld().getMobileChunk() != null && this.getMovingWorld().getMobileChunk().side().isServer()) {
            return (MobileChunkServer)this.getMovingWorld().getMobileChunk();
        }
        return null;
    }

    @Override
    public void onChunkUpdate() {
        super.onChunkUpdate();
        if (this.getMobileChunkServer() != null) {
            if (!this.firstChunkUpdate) {
                if (!this.getMobileChunkServer().getBlockQueue().isEmpty()) {
                    new MovingWorldBlockChangeMessage(this.getMovingWorld(), ChunkIO.writeCompressed(this.getMovingWorld().getMobileChunk(), this.getMobileChunkServer().getBlockQueue())).sendToAllWatching((Entity)this.getMovingWorld());
                    MovingWorldMod.LOG.debug("MobileChunk block change detected, sending packet to all players watching " + this.getMovingWorld().toString());
                }
                if (!this.getMobileChunkServer().getTileQueue().isEmpty()) {
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    NBTTagList list = new NBTTagList();
                    for (BlockPos tilePosition : this.getMobileChunkServer().getTileQueue()) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        if (this.getMobileChunkServer().func_175625_s(tilePosition) == null) continue;
                        TileEntity te = this.getMobileChunkServer().func_175625_s(tilePosition);
                        if (te instanceof TileMovingMarkingBlock) {
                            ((TileMovingMarkingBlock)te).writeNBTForSending(nbt);
                        } else {
                            te.func_189515_b(nbt);
                        }
                        list.func_74742_a((NBTBase)nbt);
                    }
                    tagCompound.func_74782_a("list", (NBTBase)list);
                    new MovingWorldTileChangeMessage(this.getMovingWorld(), tagCompound).sendToAllWatching((Entity)this.getMovingWorld());
                    MovingWorldMod.LOG.debug("MobileChunk tile change detected, sending packet to all players watching " + this.getMovingWorld().toString());
                }
            }
            this.getMobileChunkServer().getTileQueue().clear();
            this.getMobileChunkServer().getBlockQueue().clear();
        }
        this.firstChunkUpdate = false;
    }
}

