/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.modifiers.armor;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import c4.conarm.common.armor.utils.ArmorTagUtil;
import c4.conarm.lib.armor.ArmorNBT;
import c4.conarm.lib.modifiers.ArmorModifierTrait;
import c4.conarm.lib.tinkering.TinkersArmor;
import com.google.common.base.Throwables;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import landmaster.plustic.api.Sounds;
import landmaster.plustic.config.Config;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.net.PacketSJKey;
import landmaster.plustic.net.PacketSJSyncParticles;
import landmaster.plustic.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.opengl.GL11;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.utils.TagUtil;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.handler.KeyTracker;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.handler.SyncHandler;
import tonius.simplyjetpacks.item.Jetpack;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.SJStringHelper;

public class JetpackPancakeHippos
extends ArmorModifierTrait {
    private static final ArrayList<KeyBinding> keys;
    private static final Set<RenderLivingBase<?>> layerAdded;
    private static ParticleType lastJetpackState0;
    private static boolean wearingJetpack0;
    private static boolean sprintKeyCheck0;
    public static final Map<Jetpack, JetpackPancakeHippos> jetpackpancakehippos;
    public final Jetpack jetpack;
    private static final Int2ObjectMap<ParticleType> lastJetpackState;
    private static final Int2ObjectMap<ParticleType> jetpackState;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        Utils.getModifiers(chestStack).stream().filter(trait -> trait instanceof JetpackPancakeHippos).findAny().ifPresent(arg_0 -> JetpackPancakeHippos.lambda$onKeyInput$1(chestStack, (EntityPlayer)player, arg_0));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(receiveCanceled=true)
    public static void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g != null && (Minecraft.func_71410_x().field_71462_r == null || tonius.simplyjetpacks.config.Config.showHUDWhileChatting && Minecraft.func_71410_x().field_71462_r instanceof GuiChat) && !Minecraft.func_71410_x().field_71474_y.field_74319_N && !Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            ItemStack chestplate = Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
            Utils.getModifiers(chestplate).stream().filter(trait -> trait instanceof JetpackPancakeHippos).findAny().ifPresent(trait -> {
                ArrayList<String> info = new ArrayList<String>();
                ((JetpackPancakeHippos)((Object)trait)).addHUDInfo(info, chestplate, tonius.simplyjetpacks.config.Config.enableStateHUD);
                if (info.isEmpty()) {
                    return;
                }
                GL11.glPushMatrix();
                Minecraft.func_71410_x().field_71460_t.func_78478_c();
                GL11.glScaled((double)tonius.simplyjetpacks.config.Config.HUDScale, (double)tonius.simplyjetpacks.config.Config.HUDScale, (double)1.0);
                int i = 0;
                for (String s : info) {
                    RenderUtils.drawStringAtHUDPosition((String)s, (RenderUtils.HUDPositions)RenderUtils.HUDPositions.values()[tonius.simplyjetpacks.config.Config.HUDPosition], (FontRenderer)Minecraft.func_71410_x().field_71466_p, (int)tonius.simplyjetpacks.config.Config.HUDOffsetX, (int)tonius.simplyjetpacks.config.Config.HUDOffsetY, (double)tonius.simplyjetpacks.config.Config.HUDScale, (int)0xEEEEEE, (boolean)true, (int)i);
                    ++i;
                }
                GL11.glPopMatrix();
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderJetpack(final RenderLivingEvent.Pre<?> event) {
        if (!layerAdded.contains(event.getRenderer())) {
            layerAdded.add(event.getRenderer());
            event.getRenderer().func_177094_a((LayerRenderer)new LayerBipedArmor(event.getRenderer()){
                private Optional<Jetpack> jetpackOpt;
                {
                    super(x0);
                    this.jetpackOpt = Optional.empty();
                }

                public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                    this.jetpackOpt = Utils.getModifiers(event.getEntity().func_184582_a(EntityEquipmentSlot.CHEST)).stream().filter(trait -> trait instanceof JetpackPancakeHippos).findAny().map(modifier -> ((JetpackPancakeHippos)modifier).jetpack);
                    this.jetpackOpt.ifPresent(jetpack -> this.func_188361_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST));
                }

                protected ModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped model) {
                    if (slot == EntityEquipmentSlot.CHEST) {
                        return this.jetpackOpt.filter(jetpack -> tonius.simplyjetpacks.config.Config.enableArmor3DModels).map(jetpack -> RenderUtils.getArmorModel((Jetpack)jetpack, (EntityLivingBase)entity)).orElse(super.getArmorModelHook(entity, itemStack, slot, model));
                    }
                    return super.getArmorModelHook(entity, itemStack, slot, model);
                }

                public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
                    if (slot == EntityEquipmentSlot.CHEST) {
                        return this.jetpackOpt.map(jetpack -> new ResourceLocation("simplyjetpacks:textures/armor/" + jetpack.getBaseName() + (tonius.simplyjetpacks.config.Config.enableArmor3DModels || jetpack.armorModel == PackModelType.FLAT ? "" : ".flat") + ".png")).orElse(TextureManager.field_194008_a);
                    }
                    return TextureManager.field_194008_a;
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (evt.phase == TickEvent.Phase.START) {
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
            Optional<Jetpack> jetpackOpt = Utils.getModifiers(stack).stream().filter(trait -> trait instanceof JetpackPancakeHippos).findAny().map(modifier -> ((JetpackPancakeHippos)modifier).jetpack);
            ParticleType particleType = jetpackOpt.map(jetpack -> JetpackPancakeHippos.getParticleType((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, stack, jetpack)).orElse(null);
            wearingJetpack0 = jetpackOpt.isPresent();
            if (lastJetpackState0 != particleType) {
                lastJetpackState0 = particleType;
                JetpackPancakeHippos.processJetpackUpdate(Minecraft.func_71410_x().field_71439_g.func_145782_y(), particleType);
            }
        } else {
            if (!Minecraft.func_71410_x().func_147113_T()) {
                IntIterator it = jetpackState.keySet().iterator();
                while (it.hasNext()) {
                    int cur = it.nextInt();
                    Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(cur);
                    if (entity == null || !(entity instanceof EntityLivingBase) || entity.field_71093_bK != Minecraft.func_71410_x().field_71439_g.field_71093_bK) {
                        it.remove();
                        continue;
                    }
                    ParticleType particle = (ParticleType)jetpackState.get(cur);
                    if (particle != null) {
                        if (entity.func_70090_H() && particle != ParticleType.NONE) {
                            particle = ParticleType.BUBBLE;
                        }
                        SimplyJetpacks.proxy.showJetpackParticles((World)Minecraft.func_71410_x().field_71441_e, (EntityLivingBase)entity, particle);
                        if (!tonius.simplyjetpacks.config.Config.jetpackSounds || Sounds.PTSoundJetpack.isPlayingFor(entity.func_145782_y())) continue;
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new Sounds.PTSoundJetpack((EntityLivingBase)entity));
                        continue;
                    }
                    it.remove();
                }
            }
            if (sprintKeyCheck0 && Minecraft.func_71410_x().field_71439_g.field_71158_b.field_192832_b < 1.0f) {
                sprintKeyCheck0 = false;
            }
            if (!tonius.simplyjetpacks.config.Config.doubleTapSprintInAir || !wearingJetpack0 || Minecraft.func_71410_x().field_71439_g.field_70122_E || Minecraft.func_71410_x().field_71439_g.func_70051_ag() || Minecraft.func_71410_x().field_71439_g.func_184587_cr() || Minecraft.func_71410_x().field_71439_g.func_70644_a(MobEffects.field_76436_u)) {
                return;
            }
            if (!sprintKeyCheck0 && Minecraft.func_71410_x().field_71439_g.field_71158_b.field_192832_b >= 1.0f && !Minecraft.func_71410_x().field_71439_g.field_70123_F && ((float)Minecraft.func_71410_x().field_71439_g.func_71024_bL().func_75116_a() > 6.0f || Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75101_c)) {
                if (Minecraft.func_71410_x().field_71439_g.field_71156_d <= 0 && !Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d()) {
                    Minecraft.func_71410_x().field_71439_g.field_71156_d = 7;
                    sprintKeyCheck0 = true;
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_70031_b(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientDisconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent evt) {
        Sounds.PTSoundJetpack.clearPlayingFor();
    }

    public void addHUDInfo(List<String> list, ItemStack stack, boolean showState) {
        if (showState) {
            list.add(this.getHUDStatesInfo(stack));
        }
    }

    public String getHUDStatesInfo(ItemStack stack) {
        return SJStringHelper.getHUDStateText((Boolean)(!JetpackSettings.ENGINE.isOff(stack) ? 1 : 0), (Boolean)(!JetpackSettings.HOVER.isOff(stack) ? 1 : 0), null);
    }

    public JetpackPancakeHippos(Jetpack jetpack) {
        super("jetpackpancakehippos_" + jetpack.name().toLowerCase(Locale.US), 6337279);
        this.jetpack = jetpack;
    }

    public boolean canApplyTogether(IToolMod otherModifier) {
        return super.canApplyTogether(otherModifier) && !(otherModifier instanceof JetpackPancakeHippos);
    }

    public boolean canApplyCustom(ItemStack stack) {
        return EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST && super.canApplyCustom(stack);
    }

    public static void processJetpackUpdate(int entityId, ParticleType particleType) {
        if (particleType != null) {
            jetpackState.put(entityId, (Object)particleType);
        } else {
            jetpackState.remove(entityId);
        }
    }

    public static Int2ObjectMap<ParticleType> getJetpackStates() {
        return jetpackState;
    }

    public void onArmorTick(ItemStack armor, World world, EntityPlayer player) {
        this.flyUser(player, armor, false);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent evt) {
        if (!evt.getEntityLiving().field_70170_p.field_72995_K) {
            ParticleType jetpackState = null;
            ItemStack armor = evt.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST);
            Jetpack jetpack = null;
            if (armor.func_77973_b() instanceof TinkersArmor) {
                jetpack = Utils.getModifiers(armor).stream().filter(trait -> trait instanceof JetpackPancakeHippos).findAny().map(trait -> ((JetpackPancakeHippos)trait).jetpack).orElse(null);
            }
            if (jetpack != null) {
                jetpackState = JetpackPancakeHippos.getParticleType(evt.getEntityLiving(), armor, jetpack);
            }
            if (jetpackState != lastJetpackState.get(evt.getEntityLiving().func_145782_y())) {
                if (jetpackState == null) {
                    lastJetpackState.remove(evt.getEntityLiving().func_145782_y());
                } else {
                    lastJetpackState.put(evt.getEntityLiving().func_145782_y(), (Object)jetpackState);
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketSJSyncParticles(evt.getEntityLiving().func_145782_y(), jetpackState != null ? jetpackState.ordinal() : -1), new NetworkRegistry.TargetPoint(evt.getEntityLiving().field_71093_bK, evt.getEntityLiving().field_70165_t, evt.getEntityLiving().field_70163_u, evt.getEntityLiving().field_70161_v, 256.0));
            } else if (jetpack != null && evt.getEntityLiving().field_70170_p.func_82737_E() % 160L == 0L) {
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketSJSyncParticles(evt.getEntityLiving().func_145782_y(), jetpackState != null ? jetpackState.ordinal() : -1), new NetworkRegistry.TargetPoint(evt.getEntityLiving().field_71093_bK, evt.getEntityLiving().field_70165_t, evt.getEntityLiving().field_70163_u, evt.getEntityLiving().field_70161_v, 256.0));
            }
            if (evt.getEntityLiving().field_70170_p.func_82737_E() % 200L == 0L) {
                IntIterator itr = lastJetpackState.keySet().iterator();
                while (itr.hasNext()) {
                    int entityId = itr.nextInt();
                    if (evt.getEntityLiving().field_70170_p.func_73045_a(entityId) != null) continue;
                    itr.remove();
                }
            }
        }
    }

    public static ParticleType getParticleType(EntityLivingBase user, ItemStack stack, Jetpack jetpack) {
        boolean flyKeyDown = SyncHandler.isFlyKeyDown((EntityLivingBase)user);
        if (!JetpackSettings.ENGINE.isOff(stack) && JetpackPancakeHippos.searchStorage(user, 1).isPresent() && (flyKeyDown || !JetpackSettings.HOVER.isOff(stack) && !user.field_70122_E && user.field_70181_x < 0.0)) {
            return jetpack.defaultParticleType;
        }
        return null;
    }

    protected int getFuelUsage(ItemStack stack) {
        if (this.jetpack.getBaseName().contains("enderium")) {
            return (int)Math.round((double)this.jetpack.getFuelUsage() * 0.8);
        }
        return this.jetpack.getFuelUsage();
    }

    protected static Optional<IEnergyStorage> searchStorage(EntityLivingBase elb, int fuelUsage) {
        ItemStack energyStack;
        int i;
        Optional<IEnergyStorage> storage = Optional.empty();
        if (elb.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler cap = (IItemHandler)elb.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (i = 0; i < cap.getSlots() && !(storage = Optional.ofNullable((energyStack = cap.getStackInSlot(i)).getCapability(CapabilityEnergy.ENERGY, null)).filter(raw -> raw.extractEnergy(fuelUsage, true) >= fuelUsage)).isPresent(); ++i) {
            }
        }
        if (!storage.isPresent() && elb instanceof EntityPlayer) {
            IBaublesItemHandler ib = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)elb));
            for (i = 0; i < ib.getSlots() && !(storage = Optional.ofNullable((energyStack = ib.getStackInSlot(i)).getCapability(CapabilityEnergy.ENERGY, null)).filter(raw -> raw.extractEnergy(fuelUsage, true) >= fuelUsage)).isPresent(); ++i) {
            }
        }
        return storage;
    }

    protected void flyUser(EntityPlayer user, ItemStack stack, boolean force) {
        int fuelUsage = (int)(user.func_70051_ag() ? Math.round((double)this.getFuelUsage(stack) * this.jetpack.sprintFuelModifier) : (long)this.getFuelUsage(stack));
        Optional<IEnergyStorage> storage = JetpackPancakeHippos.searchStorage((EntityLivingBase)user, fuelUsage);
        if (!JetpackSettings.ENGINE.isOff(stack)) {
            boolean hoverMode = !JetpackSettings.HOVER.isOff(stack);
            double hoverSpeed = tonius.simplyjetpacks.config.Config.invertHoverSneakingBehavior == SyncHandler.isDescendKeyDown((EntityLivingBase)user) ? this.jetpack.speedVerticalHoverSlow : this.jetpack.speedVerticalHover;
            boolean flyKeyDown = force || SyncHandler.isFlyKeyDown((EntityLivingBase)user);
            boolean descendKeyDown = SyncHandler.isDescendKeyDown((EntityLivingBase)user);
            double currentAccel = this.jetpack.accelVertical * (user.field_70181_x < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = this.jetpack.speedVertical * (user.func_70090_H() ? 0.4 : 1.0);
            if (flyKeyDown || hoverMode && !user.field_70122_E) {
                if (this.jetpack.usesFuel && storage.isPresent()) {
                    storage.get().extractEnergy(fuelUsage, false);
                }
                if (!this.jetpack.usesFuel || storage.map(IEnergyStorage::getEnergyStored).filter(e -> e > 0).isPresent()) {
                    user.field_70181_x = flyKeyDown ? (!hoverMode ? Math.min(user.field_70181_x + currentAccel, currentSpeedVertical) : (descendKeyDown ? Math.min(user.field_70181_x + currentAccel, -this.jetpack.speedVerticalHoverSlow) : Math.min(user.field_70181_x + currentAccel, this.jetpack.speedVerticalHover))) : Math.min(user.field_70181_x + currentAccel, -hoverSpeed);
                    float speedSideways = (float)(user.func_70093_af() ? this.jetpack.speedSideways * 0.5 : this.jetpack.speedSideways);
                    float speedForward = (float)(user.func_70051_ag() ? (double)speedSideways * this.jetpack.sprintSpeedModifier : (double)speedSideways);
                    if (SyncHandler.isForwardKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(0.0f, 0.0f, speedForward, speedForward);
                    }
                    if (SyncHandler.isBackwardKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(0.0f, 0.0f, -speedSideways, speedSideways * 0.8f);
                    }
                    if (SyncHandler.isLeftKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(speedSideways, 0.0f, 0.0f, speedSideways);
                    }
                    if (SyncHandler.isRightKeyDown((EntityLivingBase)user)) {
                        user.func_191958_b(-speedSideways, 0.0f, 0.0f, speedSideways);
                    }
                    if (!user.field_70170_p.field_72995_K) {
                        user.field_70143_R = 0.0f;
                        if (user instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)user).field_71135_a.field_147365_f = 0;
                        }
                    }
                }
            }
        }
        if (!(user.field_70170_p.field_72995_K || !this.jetpack.emergencyHoverMode || JetpackSettings.EHOVER.isOff(stack) || this.jetpack.usesFuel && !storage.map(IEnergyStorage::getEnergyStored).filter(e -> e > 0).isPresent() || !JetpackSettings.HOVER.isOff(stack) && !JetpackSettings.ENGINE.isOff(stack))) {
            if (user.field_70163_u < -5.0) {
                this.doEHover(stack, user);
            } else if (!user.field_71075_bZ.field_75098_d && user.field_70143_R - 1.2f >= user.func_110143_aJ()) {
                for (int j = 0; j <= 16; ++j) {
                    int z;
                    int y;
                    int x = Math.round((float)user.field_70165_t - 0.5f);
                    if (user.field_70170_p.func_175623_d(new BlockPos(x, y = Math.round((float)user.field_70163_u) - j, z = Math.round((float)user.field_70161_v - 0.5f)))) continue;
                    this.doEHover(stack, user);
                    break;
                }
            }
        }
    }

    protected void doEHover(ItemStack armor, EntityPlayer user) {
        JetpackSettings.ENGINE.setOff(armor, false);
        JetpackSettings.HOVER.setOff(armor, false);
        ITextComponent msg = SJStringHelper.localizeNew((String)"chat.itemJetpack.emergencyHoverMode.msg", (Object[])new Object[0]);
        msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        user.func_146105_b(msg, true);
    }

    public String getLocalizedName() {
        return Util.translate((String)"modifier.%s.name", (Object[])new Object[]{"jetpackpancakehippos"});
    }

    public String getLocalizedDesc() {
        return Util.translate((String)"modifier.%s.desc", (Object[])new Object[]{"jetpackpancakehippos"});
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ArmorNBT data = ArmorTagUtil.getArmorStats((NBTTagCompound)rootCompound);
        data.durability = (int)((float)data.durability + (float)this.jetpack.fuelCapacity * Config.jetpackDurabilityBonusScale);
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)data.get());
    }

    private static /* synthetic */ void lambda$onKeyInput$1(ItemStack chestStack, EntityPlayer player, IModifier trait) {
        for (KeyBinding keyBindings : keys) {
            int button = keyBindings.func_151463_i();
            if (button <= 0 || !keyBindings.func_151468_f()) continue;
            JetpackSettings setting = null;
            if (keyBindings.func_151464_g().equals("simplyjetpacks.keybind.engine")) {
                setting = JetpackSettings.ENGINE;
            } else if (keyBindings.func_151464_g().equals("simplyjetpacks.keybind.hover")) {
                setting = JetpackSettings.HOVER;
            } else if (keyBindings.func_151464_g().equals("simplyjetpacks.keybind.emergencyhover")) {
                setting = JetpackSettings.EHOVER;
            }
            if (setting == null) continue;
            boolean oldState = setting.isOff(chestStack);
            if (tonius.simplyjetpacks.config.Config.enableStateMessages) {
                String unlocTemp = setting.getStateMsgUnloc();
                ITextComponent state = SJStringHelper.localizeNew((String)(oldState ? "chat.enabled" : "chat.disabled"), (Object[])new Object[0]);
                state.func_150255_a(new Style().func_150238_a(oldState ? TextFormatting.GREEN : TextFormatting.RED));
                player.func_146105_b(SJStringHelper.localizeNew((String)unlocTemp, (Object[])new Object[]{state}), true);
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSJKey(setting));
        }
    }

    static {
        ArrayList temp;
        block2: {
            MinecraftForge.EVENT_BUS.register(JetpackPancakeHippos.class);
            temp = null;
            try {
                Field f = KeyTracker.class.getDeclaredField("keys");
                f.setAccessible(true);
                temp = MethodHandles.lookup().unreflectGetter(f).invokeExact();
            }
            catch (Throwable e) {
                if (FMLCommonHandler.instance().getSide() != Side.CLIENT) break block2;
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        keys = temp;
        layerAdded = Collections.newSetFromMap(new WeakHashMap());
        lastJetpackState0 = null;
        wearingJetpack0 = false;
        sprintKeyCheck0 = false;
        jetpackpancakehippos = Arrays.stream(Jetpack.values()).filter(jetpack -> !jetpack.isArmored).collect(Collectors.toMap(Function.identity(), JetpackPancakeHippos::new, (a, b) -> b, () -> new EnumMap(Jetpack.class)));
        lastJetpackState = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        jetpackState = new Int2ObjectOpenHashMap();
    }

    public static enum JetpackSettings {
        ENGINE,
        HOVER,
        EHOVER;


        public String getNBTKey() {
            return "PlusTiC_SJ2_" + this.name();
        }

        public boolean isOff(ItemStack stack) {
            return TagUtil.getTagSafe((ItemStack)stack).func_74764_b(this.getNBTKey());
        }

        public void setOff(ItemStack stack, boolean off) {
            if (off) {
                TagUtil.getTagSafe((ItemStack)stack).func_74757_a(this.getNBTKey(), false);
            } else {
                TagUtil.getTagSafe((ItemStack)stack).func_82580_o(this.getNBTKey());
            }
        }

        public String getStateMsgUnloc() {
            switch (this) {
                case EHOVER: {
                    return "chat.itemJetpack.emergencyHoverMode";
                }
                case ENGINE: {
                    return "chat.itemJetpack.on";
                }
                case HOVER: {
                    return "chat.itemJetpack.hoverMode";
                }
            }
            return "";
        }
    }
}

