/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.modules;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.config.Config;
import landmaster.plustic.fluids.FluidMolten;
import landmaster.plustic.modules.IModule;
import landmaster.plustic.tools.stats.BatteryCellMaterialStats;
import landmaster.plustic.traits.DevilsStrength;
import landmaster.plustic.traits.Elemental;
import landmaster.plustic.traits.Explosive;
import landmaster.plustic.traits.Global;
import landmaster.plustic.traits.NickOfTime;
import landmaster.plustic.traits.Terrafirma;
import landmaster.plustic.util.EmeraldBoltCoreCastingRecipe;
import landmaster.plustic.util.OreRegisterPromise;
import landmaster.plustic.util.Utils;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.tools.TinkerTraits;

@Mod.EventBusSubscriber(modid="plustic")
public class ModuleBase
implements IModule {
    private static CompletableFuture<?> emeraldStage = new CompletableFuture();
    private static boolean usePlusTiCInvarFluid = false;

    @Override
    public void init() {
        if (Config.base) {
            Material tnt = new Material("tnt", TextFormatting.RED);
            tnt.addTrait((ITrait)Explosive.explosive);
            tnt.addItem(Blocks.field_150335_W, 144);
            tnt.setRepresentativeItem(Blocks.field_150335_W);
            tnt.setCraftable(true);
            PlusTiC.proxy.setRenderInfo(tnt, 0xFF4F4F);
            TinkerRegistry.addMaterialStats((Material)tnt, (IMaterialStats)new ArrowShaftMaterialStats(0.95f, 0));
            PlusTiC.materials.put("tnt", tnt);
            Material emerald = new Material("emerald_plustic", TextFormatting.GREEN);
            emerald.addTrait((ITrait)Terrafirma.terrafirma.get(0));
            emerald.addTrait((ITrait)Elemental.elemental, "head");
            emerald.addItem("gemEmerald", 1, 144);
            emerald.setRepresentativeItem(Items.field_151166_bC);
            emerald.setCraftable(false).setCastable(true);
            PlusTiC.proxy.setRenderInfo(emerald, 1301330);
            CompletionStage emeraldStage1 = emeraldStage.thenRun(() -> emerald.setFluid((Fluid)TinkerFluids.emerald));
            TinkerRegistry.addMaterialStats((Material)emerald, (IMaterialStats)new HeadMaterialStats(1222, 7.0f, 7.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.1f, 0), new ExtraMaterialStats(70), new BowMaterialStats(1.1f, 1.0f, 0.9f)});
            PlusTiC.materials.put("emerald", emerald);
            PlusTiC.materialIntegrationStages.put("emerald", emeraldStage1);
            Utils.ItemMatGroup alumiteGroup = Utils.registerMatGroup("alumite");
            Material alumite = new Material("alumite", TextFormatting.RED);
            alumite.addTrait((ITrait)Global.global);
            alumite.addItem("ingotAlumite", 1, 144);
            alumite.setCraftable(false).setCastable(true);
            alumite.setRepresentativeItem(alumiteGroup.ingot);
            PlusTiC.proxy.setRenderInfo(alumite, 16769265);
            FluidMolten alumiteFluid = Utils.fluidMetal("alumite", 16769265);
            alumiteFluid.setTemperature(890);
            Utils.initFluidMetal((Fluid)alumiteFluid);
            alumite.setFluid((Fluid)alumiteFluid);
            TinkerRegistry.addMaterialStats((Material)alumite, (IMaterialStats)new HeadMaterialStats(700, 6.8f, 5.5f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.1f, 70), new ExtraMaterialStats(80), new BowMaterialStats(0.65f, 1.6f, 7.0f)});
            PlusTiC.materials.put("alumite", alumite);
            if (TinkerRegistry.getMaterial((String)"nickel") == Material.UNKNOWN) {
                Material nickel = new Material("nickel", TextFormatting.YELLOW);
                nickel.addTrait((ITrait)NickOfTime.nickOfTime, "head");
                nickel.addTrait((ITrait)TinkerTraits.magnetic);
                nickel.addItem("ingotNickel", 1, 144);
                nickel.setCraftable(false).setCastable(true);
                new OreRegisterPromise("ingotNickel", new String[0]).thenAccept(arg_0 -> ((Material)nickel).setRepresentativeItem(arg_0));
                PlusTiC.proxy.setRenderInfo(nickel, 16775566);
                nickel.setFluid((Fluid)TinkerFluids.nickel);
                TinkerRegistry.addMaterialStats((Material)nickel, (IMaterialStats)new HeadMaterialStats(460, 6.0f, 4.5f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, -5), new ExtraMaterialStats(70), PlusTiC.justWhy, new FletchingMaterialStats(0.95f, 1.05f), new BatteryCellMaterialStats(75000)});
                PlusTiC.materials.put("nickel", nickel);
            }
            if (TinkerRegistry.getMaterial((String)"invar") == Material.UNKNOWN) {
                Utils.ItemMatGroup invarGroup = Utils.registerMatGroup("invar");
                Material invar = new Material("invar", 0xD6D6D6);
                invar.addTrait((ITrait)DevilsStrength.devilsstrength);
                invar.addTrait((ITrait)TinkerTraits.magnetic);
                invar.addItem("ingotInvar", 1, 144);
                invar.setCraftable(false).setCastable(true);
                invar.setRepresentativeItem(invarGroup.ingot);
                PlusTiC.proxy.setRenderInfo(invar, 0xD6D6D6);
                if (!FluidRegistry.isFluidRegistered((String)"invar")) {
                    usePlusTiCInvarFluid = true;
                    FluidMolten invarFluid = Utils.fluidMetal("invar", 0xD6D6D6);
                    invarFluid.setTemperature(1000);
                    Utils.initFluidMetal((Fluid)invarFluid);
                }
                invar.setFluid(FluidRegistry.getFluid((String)"invar"));
                TinkerRegistry.addMaterialStats((Material)invar, (IMaterialStats)new HeadMaterialStats(600, 6.0f, 5.0f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.3f, 0), new ExtraMaterialStats(100), PlusTiC.justWhy, new FletchingMaterialStats(1.0f, 1.15f)});
                PlusTiC.materials.put("invar", invar);
            }
            if (TinkerRegistry.getMaterial((String)"iridium") == Material.UNKNOWN) {
                Material iridium = new Material("iridium", TextFormatting.GRAY);
                iridium.addTrait((ITrait)TinkerTraits.dense);
                iridium.addTrait((ITrait)TinkerTraits.alien, "head");
                iridium.addItem("ingotIridium", 1, 144);
                iridium.setCraftable(false).setCastable(true);
                new OreRegisterPromise("ingotIridium", new String[0]).thenAccept(arg_0 -> ((Material)iridium).setRepresentativeItem(arg_0));
                PlusTiC.proxy.setRenderInfo(iridium, 0xE5E5E5);
                if (!FluidRegistry.isFluidRegistered((String)"iridium")) {
                    FluidMolten iridiumFluid = Utils.fluidMetal("iridium", 0xE5E5E5);
                    iridiumFluid.setTemperature(810);
                    Utils.initFluidMetal((Fluid)iridiumFluid);
                }
                iridium.setFluid(FluidRegistry.getFluid((String)"iridium"));
                TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)new HeadMaterialStats(520, 6.0f, 5.8f, 2));
                TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)new HandleMaterialStats(1.15f, -20));
                TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)new ExtraMaterialStats(60));
                TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)PlusTiC.justWhy);
                PlusTiC.materials.put("iridium", iridium);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemRegEvent(RegistryEvent.Register<Item> event) {
        emeraldStage.complete(null);
    }

    @Override
    public void init2() {
        Optional.ofNullable(PlusTiC.materials.get("alumite")).map(Material::getFluid).ifPresent(alumiteFluid -> {
            if (FluidRegistry.isFluidRegistered((Fluid)TinkerFluids.aluminum)) {
                TinkerRegistry.registerAlloy((FluidStack)new FluidStack(alumiteFluid, 3), (FluidStack[])new FluidStack[]{new FluidStack((Fluid)TinkerFluids.aluminum, 5), new FluidStack((Fluid)TinkerFluids.iron, 2), new FluidStack((Fluid)TinkerFluids.obsidian, 2)});
            }
        });
        Optional.ofNullable(PlusTiC.materials.get("invar")).map(Material::getFluid).ifPresent(invarFluid -> {
            if (usePlusTiCInvarFluid && FluidRegistry.isFluidRegistered((Fluid)TinkerFluids.nickel)) {
                TinkerRegistry.registerAlloy((FluidStack)new FluidStack(invarFluid, 3), (FluidStack[])new FluidStack[]{new FluidStack((Fluid)TinkerFluids.iron, 2), new FluidStack((Fluid)TinkerFluids.nickel, 1)});
            }
        });
        if (PlusTiC.materials.containsKey("emerald")) {
            TinkerRegistry.registerTableCasting((ICastingRecipe)EmeraldBoltCoreCastingRecipe.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onCastingRecipeRegister(TinkerRegisterEvent.TableCastingRegisterEvent event) {
        if (event.getRecipe() instanceof CastingRecipe && ((CastingRecipe)event.getRecipe()).getResult().func_77973_b() instanceof IMaterialItem && ((CastingRecipe)event.getRecipe()).getFluid().getFluid().equals(TinkerFluids.emerald)) {
            FluidStack fs = ((CastingRecipe)event.getRecipe()).getFluid();
            if (fs.amount % 72 != 0) {
                return;
            }
            fs.amount = fs.amount * 666 / 144;
        }
    }

    @SubscribeEvent
    public static void onMeltingRecipeRegister(TinkerRegisterEvent.MeltingRegisterEvent event) {
        if (((MeltingRecipe)event.getRecipe()).input.getInputs().stream().anyMatch(stack -> stack.func_77973_b() instanceof IMaterialItem) && ((MeltingRecipe)event.getRecipe()).output.getFluid().equals(TinkerFluids.emerald)) {
            FluidStack fs = ((MeltingRecipe)event.getRecipe()).output;
            if (fs.amount % 72 != 0) {
                return;
            }
            fs.amount = fs.amount * 666 / 144;
        }
    }
}

