/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.ToolTipManager;
import com.enderio.core.client.gui.widget.GuiToolTip;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

public abstract class GuiScreenBase
extends GuiScreen
implements ToolTipManager.ToolTipRenderer,
IGuiScreen {
    @Nonnull
    protected ToolTipManager ttMan = new ToolTipManager();
    protected int xSize = 176;
    protected int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    protected boolean drawButtons = true;

    protected GuiScreenBase() {
    }

    protected GuiScreenBase(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
    }

    @Override
    public void addToolTip(@Nonnull GuiToolTip toolTip) {
        this.ttMan.addToolTip(toolTip);
    }

    @Override
    public boolean removeToolTip(@Nonnull GuiToolTip toolTip) {
        return this.ttMan.removeToolTip(toolTip);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.drawBackgroundLayer(par3, par1, par2);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179133_A();
        if (this.drawButtons) {
            RenderHelper.func_74520_c();
            super.func_73863_a(par1, par2, par3);
        }
        GlStateManager.func_179108_z();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        this.drawForegroundLayer(par1, par2);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    protected abstract void drawBackgroundLayer(float var1, int var2, int var3);

    protected final void drawForegroundLayer(int mouseX, int mouseY) {
        this.drawForegroundImpl(mouseX, mouseY);
        this.ttMan.drawTooltips(this, mouseX, mouseY);
    }

    protected void drawForegroundImpl(int mouseX, int mouseY) {
    }

    @Override
    public void drawHoveringToolTipText(@Nonnull List<String> par1List, int par2, int par3, @Nonnull FontRenderer font) {
        super.drawHoveringText(par1List, par2, par3, font);
    }

    @Override
    public int getGuiRootLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiRootTop() {
        return this.guiTop;
    }

    @Override
    public int getGuiXSize() {
        return this.xSize;
    }

    @Override
    public int getGuiYSize() {
        return this.xSize;
    }

    @Override
    @Nonnull
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Nonnull
    public <T extends GuiButton> T func_189646_b(@Nonnull T button) {
        if (!this.field_146292_n.contains(button)) {
            this.field_146292_n.add(button);
        }
        return button;
    }

    @Override
    public void removeButton(@Nonnull GuiButton button) {
        this.field_146292_n.remove(button);
    }

    @Override
    public void doActionPerformed(@Nonnull GuiButton guiButton) throws IOException {
        this.func_146284_a(guiButton);
    }

    @Override
    public int getOverlayOffsetXLeft() {
        return 0;
    }

    @Override
    public int getOverlayOffsetXRight() {
        return 0;
    }

    @Override
    @Nonnull
    public final <T extends GuiButton> T addGuiButton(@Nonnull T button) {
        return this.func_189646_b(button);
    }
}

