/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class ContainerEnderCap<T extends IItemHandler, S extends TileEntity>
extends Container
implements GhostSlot.IGhostSlotAware {
    @Nonnull
    protected final Map<Slot, Point> slotLocations = Maps.newLinkedHashMap();
    protected int startPlayerSlot;
    protected int endPlayerSlot;
    protected int startHotBarSlot;
    protected int endHotBarSlot;
    @Nonnull
    private final T inv;
    @Nonnull
    private final InventoryPlayer playerInv;
    @Nullable
    private final S te;
    private boolean initRan = false;

    public Map<Slot, Point> getSlotLocations() {
        return this.slotLocations;
    }

    @Nonnull
    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public ContainerEnderCap(@Nonnull InventoryPlayer playerInv, @Nonnull T itemHandler, @Nullable S te) {
        this.inv = (IItemHandler)ContainerEnderCap.checkNotNull(itemHandler);
        this.playerInv = ContainerEnderCap.checkNotNull(playerInv);
        this.te = te;
        this.init();
    }

    public ContainerEnderCap(@Nonnull InventoryPlayer playerInv, @Nonnull T itemHandler, @Nullable S te, boolean unused) {
        this.inv = (IItemHandler)ContainerEnderCap.checkNotNull(itemHandler);
        this.playerInv = ContainerEnderCap.checkNotNull(playerInv);
        this.te = te;
    }

    @Nonnull
    public final <X> X init() {
        int i;
        if (this.initRan) {
            throw new RuntimeException("Ender IO Internal Error 10T (report this to the Ender IO devs)");
        }
        this.addSlots();
        int x = this.getPlayerInventoryOffset().x;
        int y = this.getPlayerInventoryOffset().y;
        this.startPlayerSlot = this.field_75151_b.size();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                Slot slot = new Slot((IInventory)this.playerInv, j + i * 9 + 9, x + j * 18, y + i * 18);
                this.func_75146_a(slot);
            }
        }
        this.endPlayerSlot = this.field_75151_b.size();
        this.startHotBarSlot = this.field_75151_b.size();
        for (i = 0; i < 9; ++i) {
            Slot slot = new Slot((IInventory)this.playerInv, i, x + i * 18, y + 58);
            this.func_75146_a(slot);
        }
        this.endHotBarSlot = this.field_75151_b.size();
        this.initRan = true;
        return (X)this;
    }

    @Nonnull
    protected Slot func_75146_a(@Nonnull Slot slotIn) {
        this.slotLocations.put(slotIn, new Point(slotIn.field_75223_e, slotIn.field_75221_f));
        return super.func_75146_a(slotIn);
    }

    @Nonnull
    public List<Slot> getPlayerSlots() {
        return this.field_75151_b.stream().filter(x -> x.field_75224_c == this.playerInv).collect(Collectors.toList());
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(0, 54);
    }

    @Nonnull
    public T getItemHandler() {
        return this.inv;
    }

    @Nullable
    public S getTileEntity() {
        return this.te;
    }

    @Nonnull
    public S getTileEntityNN() {
        return (S)((TileEntity)NullHelper.notnull(this.te, "Internal logic error, TE-less GUI accessing TE"));
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        if (!this.initRan) {
            throw new RuntimeException("Ender IO Internal Error 10T (report this to the Ender IO devs)");
        }
        S te2 = this.te;
        if (te2 != null) {
            World world = te2.func_145831_w();
            BlockPos pos = te2.func_174877_v();
            if (player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) > 64.0) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (te2 != tileEntity) {
                return false;
            }
        }
        return true;
    }

    protected abstract void addSlots();

    @Override
    public void setGhostSlotContents(int slot, @Nonnull ItemStack stack, int realsize) {
        if (this.te instanceof TileEntityBase) {
            ((TileEntityBase)((Object)this.te)).setGhostSlotContents(slot, stack, realsize);
        }
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer player, int fromSlotId) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(fromSlotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack2;
            ItemStack stackToMove = slot.func_75211_c();
            itemstack = stackToMove.func_77946_l();
            if (!this.mergeItemStack(stackToMove, this.mapSlotToTargets(fromSlotId))) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
            slot.func_190901_a(player, stackToMove);
            if (player.field_70170_p.field_72995_K && (itemstack2 = slot.func_75211_c()).func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    @Nonnull
    protected Collection<Slot> mapSlotToTargets(int fromSlotId) {
        ArrayList<Slot> result = new ArrayList<Slot>();
        if (fromSlotId < this.startPlayerSlot) {
            for (int i = this.startPlayerSlot; i < this.field_75151_b.size(); ++i) {
                result.add(0, (Slot)this.field_75151_b.get(i));
            }
        } else {
            for (int i = 0; i < this.startPlayerSlot; ++i) {
                result.add((Slot)this.field_75151_b.get(i));
            }
        }
        return result;
    }

    @Deprecated
    protected final boolean func_75135_a(@Nonnull ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        return false;
    }

    protected boolean mergeItemStack(ItemStack stackToMove, Collection<Slot> targets) {
        boolean result = false;
        if (stackToMove.func_77985_e()) {
            for (Slot slot : targets) {
                int maxStackSize;
                ItemStack stackInSlot;
                if (!this.isSlotEnabled(slot) || !slot.func_75216_d() || (stackInSlot = slot.func_75211_c()).func_77973_b() != stackToMove.func_77973_b() || stackToMove.func_77981_g() && stackToMove.func_77952_i() != stackInSlot.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stackToMove, (ItemStack)stackInSlot) || !slot.func_75214_a(stackToMove) || stackToMove == stackInSlot) continue;
                int mergedSize = stackInSlot.func_190916_E() + stackToMove.func_190916_E();
                if (mergedSize <= (maxStackSize = Math.min(stackToMove.func_77976_d(), slot.func_178170_b(stackToMove)))) {
                    stackToMove.func_190920_e(0);
                    stackInSlot.func_190920_e(mergedSize);
                    slot.func_75218_e();
                    return true;
                }
                if (stackInSlot.func_190916_E() >= maxStackSize) continue;
                stackToMove.func_190918_g(maxStackSize - stackInSlot.func_190916_E());
                stackInSlot.func_190920_e(maxStackSize);
                slot.func_75218_e();
                result = true;
            }
        }
        for (Slot slot : targets) {
            if (!this.isSlotEnabled(slot) || slot.func_75216_d() || !slot.func_75214_a(stackToMove)) continue;
            ItemStack in = stackToMove.func_77946_l();
            in.func_190920_e(Math.min(in.func_190916_E(), slot.func_178170_b(stackToMove)));
            slot.func_75215_d(in);
            slot.func_75218_e();
            stackToMove.func_190918_g(in.func_190916_E());
            if (stackToMove.func_190926_b()) {
                return true;
            }
            result = true;
        }
        return result;
    }

    public void func_75142_b() {
        SPacketUpdateTileEntity updatePacket;
        super.func_75142_b();
        SPacketUpdateTileEntity sPacketUpdateTileEntity = updatePacket = this.te != null ? this.te.func_189518_D_() : null;
        if (updatePacket != null) {
            for (IContainerListener containerListener : this.field_75149_d) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)containerListener).field_71135_a.func_147359_a((Packet)updatePacket);
            }
        }
    }

    protected boolean isSlotEnabled(Slot slot) {
        return !(slot == null || slot instanceof ContainerEnder.BaseSlot && !((ContainerEnder.BaseSlot)slot).func_111238_b() || slot instanceof BaseSlotItemHandler && !((BaseSlotItemHandler)slot).func_111238_b());
    }

    public static abstract class BaseSlotItemHandler
    extends SlotItemHandler {
        public BaseSlotItemHandler(@Nonnull IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_111238_b() {
            return true;
        }
    }
}

