/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.tweaks;

import com.enderio.core.common.tweaks.Tweak;
import com.enderio.core.common.util.NullHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class SlabRecipes
extends Tweak {
    private static final String[] slabEndingsWood = new String[]{"WoodOak", "WoodSpruce", "WoodBirch", "WoodJungle", "WoodAcacia", "WoodDarkOak"};
    private static final String[] slabEndingsStone = new String[]{"Stone", "Sandstone", "Cobblestone", "Bricks", "StoneBricks", "NetherBrick", "Quartz"};
    private static final Block[] slabResults = new Block[]{Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150347_e, Blocks.field_150336_V, Blocks.field_150417_aV, Blocks.field_150385_bj, Blocks.field_150371_ca};
    public static final SlabRecipes INSTANCE = new SlabRecipes();

    SlabRecipes() {
        super("slabToBlockRecipes", "Adds recipes to turn any two slabs back into a full block");
    }

    @Override
    public void load() {
        SlabRecipes.registerSlabToBlock();
    }

    private static void addSlabRecipe(@Nonnull ItemStack stack, @Nonnull String slab) {
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(null, stack, new Object[]{slab, slab}).setRegistryName(slab + "_to_" + NullHelper.notnullM(stack.func_77973_b().getRegistryName(), "found unregistered item").func_110623_a()));
    }

    private static void registerSlabToBlock() {
        int j;
        for (j = 0; j < slabEndingsWood.length; ++j) {
            SlabRecipes.addSlabRecipe(new ItemStack(Blocks.field_150344_f, 1, j), "slab" + slabEndingsWood[j]);
        }
        for (j = 0; j < slabEndingsStone.length; ++j) {
            SlabRecipes.addSlabRecipe(new ItemStack(NullHelper.notnullM(slabResults[j], "Blocks are missing from the game")), "slab" + slabEndingsStone[j]);
        }
    }
}

