/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.energy.systems;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.modcrafters.mclib.energy.IGenericEnergyStorage;
import net.ndrei.teslacorelib.energy.IEnergySystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J+\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/ForgeEnergySystem;", "Lnet/ndrei/teslacorelib/energy/IEnergySystem;", "()V", "MODID", "", "ModId", "getModId", "()Ljava/lang/String;", "hasCapability", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "wrapCapability", "T", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)Ljava/lang/Object;", "wrapItemStack", "stack", "Lnet/minecraft/item/ItemStack;", "wrapTileEntity", "te", "Lnet/minecraft/tileentity/TileEntity;", "side", "Lnet/minecraft/util/EnumFacing;", "ReverseWrapper", "Wrapper", "tesla-core-lib"})
public final class ForgeEnergySystem
implements IEnergySystem {
    @NotNull
    public static final String MODID = "minecraft";
    public static final ForgeEnergySystem INSTANCE;

    @Override
    @NotNull
    public String getModId() {
        return MODID;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return Intrinsics.areEqual(capability, (Object)CapabilityEnergy.ENERGY);
    }

    @Override
    @Nullable
    public <T> T wrapCapability(@NotNull Capability<T> capability, @NotNull IGenericEnergyStorage energy) {
        Object object;
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
        if (Intrinsics.areEqual(capability, (Object)CapabilityEnergy.ENERGY)) {
            Wrapper wrapper = new Wrapper(energy);
            if (!(wrapper instanceof Object)) {
                wrapper = null;
            }
            object = wrapper;
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapTileEntity(@NotNull TileEntity te, @NotNull EnumFacing side) {
        IEnergyStorage energy;
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (te instanceof IEnergyStorage) {
            return new ReverseWrapper((IEnergyStorage)te);
        }
        if (te.hasCapability(CapabilityEnergy.ENERGY, side) && (energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side)) != null) {
            return new ReverseWrapper(energy);
        }
        return null;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapItemStack(@NotNull ItemStack stack) {
        IEnergyStorage energy;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.func_190926_b() && stack.hasCapability(CapabilityEnergy.ENERGY, null) && (energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return new ReverseWrapper(energy);
        }
        return null;
    }

    private ForgeEnergySystem() {
    }

    static {
        ForgeEnergySystem forgeEnergySystem;
        INSTANCE = forgeEnergySystem = new ForgeEnergySystem();
    }

    @Override
    public boolean isAvailable() {
        return IEnergySystem.DefaultImpls.isAvailable(this);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/ForgeEnergySystem$Wrapper;", "Lnet/minecraftforge/energy/IEnergyStorage;", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)V", "getEnergy", "()Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "canExtract", "", "canReceive", "extractEnergy", "", "maxExtract", "simulate", "getEnergyStored", "getMaxEnergyStored", "receiveEnergy", "maxReceive", "tesla-core-lib"})
    public static final class Wrapper
    implements IEnergyStorage {
        @NotNull
        private final IGenericEnergyStorage energy;

        public boolean canExtract() {
            return this.energy.getCanTake();
        }

        public int getMaxEnergyStored() {
            return (int)this.energy.getCapacity();
        }

        public int getEnergyStored() {
            return (int)this.energy.getStored();
        }

        public boolean canReceive() {
            return this.energy.getCanGive();
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.energy.takePower(maxExtract, simulate);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)this.energy.givePower(maxReceive, simulate);
        }

        @NotNull
        public final IGenericEnergyStorage getEnergy() {
            return this.energy;
        }

        public Wrapper(@NotNull IGenericEnergyStorage energy) {
            Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
            this.energy = energy;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/ForgeEnergySystem$ReverseWrapper;", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "energy", "Lnet/minecraftforge/energy/IEnergyStorage;", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "canGive", "", "getCanGive", "()Z", "canTake", "getCanTake", "capacity", "", "getCapacity", "()J", "getEnergy", "()Lnet/minecraftforge/energy/IEnergyStorage;", "stored", "getStored", "givePower", "power", "simulated", "takePower", "tesla-core-lib"})
    public static final class ReverseWrapper
    implements IGenericEnergyStorage {
        @NotNull
        private final IEnergyStorage energy;

        @Override
        public long getCapacity() {
            return this.energy.getMaxEnergyStored();
        }

        @Override
        public long getStored() {
            return this.energy.getEnergyStored();
        }

        @Override
        public boolean getCanGive() {
            return this.energy.canReceive();
        }

        @Override
        public long givePower(long power, boolean simulated) {
            return this.energy.receiveEnergy((int)power, simulated);
        }

        @Override
        public boolean getCanTake() {
            return this.energy.canExtract();
        }

        @Override
        public long takePower(long power, boolean simulated) {
            return this.energy.extractEnergy((int)power, simulated);
        }

        @NotNull
        public final IEnergyStorage getEnergy() {
            return this.energy;
        }

        public ReverseWrapper(@NotNull IEnergyStorage energy) {
            Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
            this.energy = energy;
        }

        @Override
        public boolean tryGive() {
            return IGenericEnergyStorage.DefaultImpls.tryGive(this);
        }

        @Override
        public boolean tryTake() {
            return IGenericEnergyStorage.DefaultImpls.tryTake(this);
        }
    }
}

