/*
 * Decompiled with CFR 0.152.
 */
package texFix;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import texFix.FixList;

@Mod(modid="texfix", name="TextureFix", version="4.0", acceptableRemoteVersions="*", clientSideOnly=true, acceptedMinecraftVersions="[1.12]")
public class TextureFix {
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.###");
    public static LinkedList<UnloadEntry> toUnload = new LinkedList();

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                TextureMap map = Minecraft.func_71410_x().func_147117_R();
                if (map == null) {
                    return;
                }
                long bytes = 0L;
                int fixed = 0;
                for (TextureAtlasSprite sprite : TextureFix.this.getData(map).values()) {
                    if (sprite.func_130098_m()) continue;
                    ++fixed;
                    bytes += (long)(sprite.func_94211_a() * sprite.func_94216_b() * 4);
                    sprite.func_110968_a((List)new FixList(sprite));
                }
                LogManager.getLogger((String)"TexFix").info("Fixed Textures: " + fixed + " Saved: " + DECIMALFORMAT.format(TextureFix.this.toMB(bytes *= (long)(1 + map.getMipmapLevels()))) + "MB (" + bytes + " bytes)");
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void markForUnload(TextureAtlasSprite sprite) {
        toUnload.add(new UnloadEntry(sprite));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (toUnload.size() > 0 && toUnload.getFirst().unload()) {
            toUnload.removeFirst();
        }
    }

    private long toMB(long data) {
        return data / 1024L / 1024L;
    }

    Map<String, TextureAtlasSprite> getData(TextureMap map) {
        try {
            Field[] fields = map.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                return (Map)field.get(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void reloadTextureData(TextureAtlasSprite sprite) {
        Minecraft mc = Minecraft.func_71410_x();
        TextureFix.reloadTextureData(sprite, mc.func_110442_L(), mc.func_147117_R());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadTextureData(TextureAtlasSprite sprite, IResourceManager manager, final TextureMap map) {
        ResourceLocation location = TextureFix.getResourceLocation(sprite, map);
        if (sprite.hasCustomLoader(manager, location)) {
            sprite.load(manager, location, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                @Override
                public TextureAtlasSprite apply(ResourceLocation t) {
                    return map.func_110572_b(t.toString());
                }
            });
        } else {
            IResource resource = null;
            try {
                resource = manager.func_110536_a(location);
                sprite.func_188539_a(resource, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (resource != null) {
                    try {
                        resource.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static ResourceLocation getResourceLocation(TextureAtlasSprite p_184396_1_, TextureMap map) {
        ResourceLocation resourcelocation = new ResourceLocation(p_184396_1_.func_94215_i());
        return new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", map.getBasePath(), resourcelocation.func_110623_a(), ".png"));
    }

    public static class UnloadEntry {
        int count = 2;
        TextureAtlasSprite sprite;

        public UnloadEntry(TextureAtlasSprite entry) {
            this.sprite = entry;
        }

        public boolean unload() {
            --this.count;
            if (this.count <= 0) {
                this.sprite.func_130103_l();
                return true;
            }
            return false;
        }
    }
}

