/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.davincisvessels.client.gui;

import com.elytradev.davincisvessels.DavincisVesselsMod;
import com.elytradev.davincisvessels.client.gui.ContainerHelm;
import com.elytradev.davincisvessels.common.entity.ShipAssemblyInteractor;
import com.elytradev.davincisvessels.common.network.HelmClientAction;
import com.elytradev.davincisvessels.common.network.message.HelmActionMessage;
import com.elytradev.davincisvessels.common.network.message.RenameShipMessage;
import com.elytradev.davincisvessels.common.tileentity.TileHelm;
import com.elytradev.movingworld.common.chunk.assembly.AssembleResult;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiHelm
extends GuiContainer {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("davincisvessels", "textures/gui/shipstatus.png");
    public final TileHelm tileEntity;
    public final EntityPlayer player;
    private GuiButton btnRename;
    private GuiButton btnAssemble;
    private GuiButton btnUndo;
    private GuiButton btnMount;
    private GuiTextField txtShipName;
    private boolean busyCompiling;

    public GuiHelm(TileHelm tileentity, EntityPlayer entityplayer) {
        super((Container)new ContainerHelm(tileentity, entityplayer));
        this.tileEntity = tileentity;
        this.player = entityplayer;
        this.field_146999_f = 256;
        this.field_147000_g = 256;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int btnx = this.field_147003_i - 100;
        int btny = this.field_147009_r + 20;
        this.field_146292_n.clear();
        this.btnRename = new GuiButton(4, btnx, btny, 100, 20, I18n.func_135052_a((String)"gui.davincis.shipstatus.rename", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnRename);
        this.btnAssemble = new GuiButton(1, btnx, btny += 20, 100, 20, I18n.func_135052_a((String)"gui.davincis.shipstatus.compile", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnAssemble);
        this.btnUndo = new GuiButton(2, btnx, btny += 20, 100, 20, I18n.func_135052_a((String)"gui.davincis.shipstatus.undo", (Object[])new Object[0]));
        this.btnUndo.field_146124_l = this.tileEntity.getPrevAssembleResult() != null && this.tileEntity.getPrevAssembleResult().getType() != AssembleResult.ResultType.RESULT_NONE;
        this.field_146292_n.add(this.btnUndo);
        this.btnMount = new GuiButton(3, btnx, btny += 20, 100, 20, I18n.func_135052_a((String)"gui.davincis.shipstatus.mount", (Object[])new Object[0]));
        this.btnMount.field_146124_l = this.tileEntity.getAssembleResult() != null && this.tileEntity.getAssembleResult().getType() == AssembleResult.ResultType.RESULT_OK;
        this.field_146292_n.add(this.btnMount);
        this.txtShipName = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 8 + this.field_146999_f / 2, this.field_147009_r + 21, 120, 10);
        this.txtShipName.func_146203_f(127);
        this.txtShipName.func_146185_a(false);
        this.txtShipName.func_146189_e(true);
        this.txtShipName.func_146205_d(false);
        this.txtShipName.func_146193_g(0xFFFFFF);
        this.txtShipName.func_146180_a(this.tileEntity.getInfo().getName());
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        int y;
        super.func_73876_c();
        this.btnUndo.field_146124_l = this.tileEntity.getPrevAssembleResult() != null && this.tileEntity.getPrevAssembleResult().getType() != AssembleResult.ResultType.RESULT_NONE;
        this.btnMount.field_146124_l = this.tileEntity.getAssembleResult() != null && this.tileEntity.getAssembleResult().getType() == AssembleResult.ResultType.RESULT_OK;
        this.btnUndo.field_146128_h = this.btnMount.field_146128_h = this.field_147003_i - 100;
        this.btnAssemble.field_146128_h = this.btnMount.field_146128_h;
        this.btnRename.field_146128_h = this.btnMount.field_146128_h;
        this.btnRename.field_146129_i = y = this.field_147009_r + 20;
        this.btnAssemble.field_146129_i = y += 20;
        this.btnUndo.field_146129_i = y += 20;
        this.btnMount.field_146129_i = y += 20;
    }

    protected void func_146979_b(int mousex, int mousey) {
        String rcodename;
        int valueColor;
        float rmass;
        int rblocks;
        int rballoons;
        int rtes;
        AssembleResult.ResultType rType;
        AssembleResult result = this.tileEntity.getAssembleResult();
        int colorTitle = 0x404040;
        int row = 8;
        int col0 = 8;
        int col1 = col0 + this.field_146999_f / 2;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.title", (Object[])new Object[0]), col0, row, colorTitle);
        row += 5;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.name", (Object[])new Object[0]), col0, row += 10, colorTitle);
        if (result == null || result != null && result.assemblyInteractor == null || result != null && result.assemblyInteractor != null && !(result.assemblyInteractor instanceof ShipAssemblyInteractor)) {
            rType = this.busyCompiling ? AssembleResult.ResultType.RESULT_BUSY_COMPILING : AssembleResult.ResultType.RESULT_NONE;
            rtes = 0;
            rballoons = 0;
            rblocks = 0;
            rmass = 0.0f;
        } else {
            rType = result.getType();
            rblocks = result.getBlockCount();
            rballoons = ((ShipAssemblyInteractor)result.assemblyInteractor).getBalloonCount();
            rtes = result.getTileEntityCount();
            rmass = result.getMass();
            if (rType != AssembleResult.ResultType.RESULT_NONE) {
                this.busyCompiling = false;
            }
        }
        switch (rType) {
            case RESULT_NONE: {
                valueColor = colorTitle;
                rcodename = "gui.davincis.shipstatus.result.none";
                break;
            }
            case RESULT_OK: {
                valueColor = 0x40A000;
                rcodename = "gui.davincis.shipstatus.result.ok";
                break;
            }
            case RESULT_OK_WITH_WARNINGS: {
                valueColor = 0xFFAA00;
                rcodename = "gui.davincis.shipstatus.result.okwarn";
                break;
            }
            case RESULT_MISSING_MARKER: {
                valueColor = 0xB00000;
                rcodename = "gui.davincis.shipstatus.result.missingmarker";
                break;
            }
            case RESULT_BLOCK_OVERFLOW: {
                valueColor = 0xB00000;
                rcodename = "gui.davincis.shipstatus.result.overflow";
                break;
            }
            case RESULT_ERROR_OCCURED: {
                valueColor = 0xB00000;
                rcodename = "gui.davincis.shipstatus.result.error";
                break;
            }
            case RESULT_BUSY_COMPILING: {
                valueColor = colorTitle;
                rcodename = "gui.davincis.shipstatus.result.busy";
                break;
            }
            case RESULT_INCONSISTENT: {
                valueColor = 0xB00000;
                rcodename = "gui.davincis.shipstatus.result.inconsistent";
                break;
            }
            default: {
                valueColor = colorTitle;
                rcodename = "gui.davincis.shipstatus.result.none";
            }
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.compilerresult", (Object[])new Object[0]), col0, row += 10, colorTitle);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)rcodename, (Object[])new Object[0]), col1, row, valueColor);
        float balloonratio = (float)rballoons / (float)rblocks;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.shiptype", (Object[])new Object[0]), col0, row += 10, colorTitle);
        if (rblocks == 0) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.type.unknown", (Object[])new Object[0]), col1, row, colorTitle);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)(balloonratio > DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().flyBalloonRatio ? "gui.davincis.shipstatus.type.airship" : "gui.davincis.shipstatus.type.boat"), (Object[])new Object[0]), col1, row, colorTitle);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.count.block", (Object[])new Object[0]), col0, row += 10, colorTitle);
        this.field_146289_q.func_78276_b(String.valueOf(rblocks), col1, row, colorTitle);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.count.balloon", (Object[])new Object[0]), col0, row += 10, colorTitle);
        this.field_146289_q.func_78276_b(String.valueOf(rballoons) + " (" + (int)(balloonratio * 100.0f) + "%)", col1, row, colorTitle);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.count.tileentity", (Object[])new Object[0]), col0, row += 10, colorTitle);
        this.field_146289_q.func_78276_b(String.valueOf(rtes), col1, row, colorTitle);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.davincis.shipstatus.mass", (Object[])new Object[0]), col0, row += 10, colorTitle);
        this.field_146289_q.func_78276_b(String.format(Locale.ROOT, "%.1f %s", Float.valueOf(rmass), I18n.func_135052_a((String)"gui.davincis.shipstatus.massunit", (Object[])new Object[0])), col1, row, colorTitle);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(BACKGROUND_TEXTURE);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.txtShipName.func_146194_f();
    }

    public void func_146284_a(GuiButton button) {
        if (button == this.btnRename) {
            if (this.txtShipName.func_146206_l()) {
                this.btnRename.field_146126_j = I18n.func_135052_a((String)"gui.davincis.shipstatus.rename", (Object[])new Object[0]);
                this.tileEntity.getInfo().setName(this.txtShipName.func_146179_b());
                this.txtShipName.func_146195_b(false);
                new RenameShipMessage(this.tileEntity, this.tileEntity.getInfo().getName()).sendToServer();
            } else {
                this.btnRename.field_146126_j = I18n.func_135052_a((String)"gui.davincis.shipstatus.done", (Object[])new Object[0]);
                this.txtShipName.func_146195_b(true);
            }
        } else if (button == this.btnAssemble) {
            new HelmActionMessage(this.tileEntity, HelmClientAction.ASSEMBLE).sendToServer();
            this.tileEntity.setAssembleResult(null);
            this.busyCompiling = true;
        } else if (button == this.btnMount) {
            new HelmActionMessage(this.tileEntity, HelmClientAction.MOUNT).sendToServer();
        } else if (button == this.btnUndo) {
            new HelmActionMessage(this.tileEntity, HelmClientAction.UNDOCOMPILE).sendToServer();
        }
    }

    protected void func_73869_a(char c, int k) {
        if (!this.func_146983_a(k)) {
            if (k == 28 && this.txtShipName.func_146206_l()) {
                this.func_146284_a(this.btnRename);
            } else if (!this.txtShipName.func_146201_a(c, k)) {
                try {
                    super.func_73869_a(c, k);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

