/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.repackage.com.elytradev.concrete.network;

import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.DefaultMarshallers;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.Marshallable;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.MarshallableMarshaller;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.Marshaller;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.field.Optional;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.exception.BadMessageException;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.reflect.accessor.Accessors;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;

class WireField<T> {
    private final Field f;
    private final Accessor<T> accessor;
    private final Marshaller<T> marshaller;
    private final Class<T> type;
    private final boolean optional;

    public WireField(Field f) {
        f.setAccessible(true);
        this.f = f;
        this.accessor = Accessors.from(f);
        try {
            this.type = f.getType();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        MarshalledAs ma = f.getAnnotation(MarshalledAs.class);
        this.marshaller = ma != null ? DefaultMarshallers.getByName(ma.value()) : (Marshallable.class.isAssignableFrom(this.type) ? new MarshallableMarshaller<T>(this.type) : DefaultMarshallers.getByType(this.type));
        boolean bl = this.optional = f.getAnnotation(Optional.class) != null;
        if (this.marshaller == null && this.type != Boolean.TYPE) {
            String annot = "";
            if (ma != null) {
                annot = "@MarshalledAs(\"" + ma.value().replace("\"", "\\\"") + "\") ";
            }
            if (this.optional) {
                annot = annot + "@Optional ";
            }
            throw new BadMessageException("Cannot find an appropriate marshaller for field " + annot + this.type + " " + f.getDeclaringClass().getName() + "." + f.getName());
        }
    }

    public T get(Object owner) {
        return this.accessor.get(owner);
    }

    public void set(Object owner, T value) {
        this.accessor.set(owner, value);
    }

    public void marshal(Object owner, ByteBuf out) {
        T value = this.accessor.get(owner);
        if (value == null) {
            throw new BadMessageException("Wire fields cannot be null (in " + this.type + " " + this.f.getDeclaringClass().getName() + "." + this.f.getName() + ")");
        }
        this.marshaller.marshal(out, value);
    }

    public void unmarshal(Object owner, ByteBuf in) {
        this.accessor.set(owner, this.marshaller.unmarshal(in));
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Class<? extends T> getType() {
        return this.type;
    }
}

