/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen;

import com.elytradev.movingworld.repackage.com.elytradev.concrete.common.ConcreteLog;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.ConcreteResourcePack;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.EnumResourceType;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.IResourceHolder;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.ResourceProvider;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class BlockStateResourceProvider
extends ResourceProvider {
    private static String SIMPLE_BLOCK_STATE;

    public BlockStateResourceProvider(ConcreteResourcePack resourcePack) {
        super(resourcePack);
    }

    @Override
    public boolean canProvide(String name) {
        return name.startsWith("assets/" + this.modID + "/blockstates/") && name.endsWith(".json");
    }

    @Override
    public InputStream provide(String name) {
        ResourceLocation resource;
        String blockID = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf("."));
        Block blockFromLocation = Block.func_149684_b((String)(this.modID + ":" + blockID));
        String modelLocation = this.modID + ":" + blockID;
        if (blockFromLocation instanceof IResourceHolder && (resource = ((IResourceHolder)blockFromLocation).getResource(EnumResourceType.MODEL, 0)) != null) {
            modelLocation = resource.toString();
            modelLocation = modelLocation.substring(modelLocation.lastIndexOf("/1"));
            modelLocation = this.modID + ":" + modelLocation;
        }
        String simpleBlockState = SIMPLE_BLOCK_STATE;
        simpleBlockState = simpleBlockState.replaceAll("%MDL%", modelLocation);
        return IOUtils.toInputStream((String)simpleBlockState);
    }

    static {
        try {
            SIMPLE_BLOCK_STATE = Resources.toString((URL)BlockStateResourceProvider.class.getResource("concreteblockstate.json"), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            ConcreteLog.error("Caught IOException loading concrete blockstate, things will definitely not work.", (Throwable)e);
        }
    }
}

