/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.Logger;
import jotato.quantumflux.helpers.EntityHelpers;
import jotato.quantumflux.items.ItemBase;
import jotato.quantumflux.registers.ItemRegister;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public class ItemMagnet
extends ItemBase
implements IBauble {
    protected static String name = "magnet";

    public ItemMagnet() {
        super(name);
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77656_e(0);
    }

    @Override
    public void initModel() {
        Logger.devLog("    Registering model for %s", this.getSimpleName());
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_77636_d(ItemStack item) {
        return ItemMagnet.isActivated(item);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStackIn = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            itemStackIn.func_77964_b(itemStackIn.func_77952_i() == 0 ? 1 : 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int i, boolean f) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            ItemMagnet.doMagnet(item, (EntityPlayer)entity, entity.func_130014_f_());
        }
    }

    private static void doMagnet(ItemStack item, EntityPlayer player, World world) {
        if (world.field_72995_K) {
            return;
        }
        if (!ItemMagnet.isActivated(item)) {
            return;
        }
        for (EntityItem entityItem : EntityHelpers.getEntitiesInRange(EntityItem.class, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, ConfigMan.magnet_range)) {
            if (entityItem.field_70128_L || entityItem.getEntityData().func_74767_n("PreventRemoteMovement")) continue;
            if (entityItem.field_70173_aa <= 1) {
                entityItem.func_174867_a(1);
            }
            entityItem.func_70100_b_(player);
        }
        for (EntityXPOrb entityXPOrb : EntityHelpers.getEntitiesInRange(EntityXPOrb.class, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, ConfigMan.magnet_range)) {
            player.field_71090_bL = 0;
            entityXPOrb.field_70532_c = 0;
            entityXPOrb.func_70100_b_(player);
        }
    }

    private static boolean isActivated(ItemStack item) {
        if (item.func_77973_b() == ItemRegister.magnet) {
            return item.func_77952_i() == 1;
        }
        return false;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && ItemMagnet.isActivated(stack)) {
            ItemMagnet.doMagnet(stack, (EntityPlayer)player, player.func_130014_f_());
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    public static void toggleMagnetWithMessage(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b()) {
            return;
        }
        if (ItemMagnet.isActivated(stack)) {
            stack.func_77964_b(0);
            player.func_145747_a((ITextComponent)new TextComponentString("Magnet disabled"));
        } else {
            stack.func_77964_b(1);
            player.func_145747_a((ITextComponent)new TextComponentString("Magnet enabled"));
        }
    }
}

