/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogHelper {
    private static Logger logger = LogManager.getLogger((String)"EnderStorage");
    private static final Set<String> stackTraces = new HashSet<String>();

    public static void log(Level logLevel, Object object) {
        logger.log(logLevel, String.valueOf(object));
    }

    public static void log(Level logLevel, String format, Object ... objects) {
        logger.log(logLevel, String.format(format, objects));
    }

    public static void log(Level logLevel, Throwable throwable, Object object) {
        logger.log(logLevel, String.valueOf(object), throwable);
    }

    public static void log(Level logLevel, Throwable throwable, String format, Object ... objects) {
        logger.log(logLevel, String.format(format, objects), throwable);
    }

    public static void big(Level level, String format, Object ... data) {
        LogHelper.big(level, 8, format, data);
    }

    public static void big(Level level, int lines, String format, Object ... data) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        LogHelper.log(level, "****************************************");
        LogHelper.log(level, "* " + format, data);
        for (int i = 2; i < lines && i < trace.length; ++i) {
            LogHelper.log(level, "*  at %s%s", trace[i].toString(), i == lines - 1 ? "..." : "");
        }
        LogHelper.log(level, "****************************************");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void errorOnce(Throwable t, String identifier, String format, Object ... data) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String stackTrace = identifier + sw.toString();
        Set<String> set = stackTraces;
        synchronized (set) {
            if (!stackTraces.contains(stackTrace)) {
                LogHelper.log(Level.ERROR, t, format, data);
                stackTraces.add(stackTrace);
            }
        }
    }
}

