/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment;

import com.bewitchment.ModConfig;
import com.bewitchment.Util;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayerHandler;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.api.message.CauldronTeleport;
import com.bewitchment.api.message.SpawnBubble;
import com.bewitchment.api.message.SpawnParticle;
import com.bewitchment.api.message.SyncBroom;
import com.bewitchment.api.message.SyncExtendedPlayer;
import com.bewitchment.api.message.TeleportPlayerClient;
import com.bewitchment.client.handler.ClientHandler;
import com.bewitchment.common.command.CommandFortune;
import com.bewitchment.common.handler.BlockDropHandler;
import com.bewitchment.common.handler.GuiHandler;
import com.bewitchment.common.handler.MaterialHandler;
import com.bewitchment.common.handler.MiscHandler;
import com.bewitchment.common.integration.thaumcraft.BewitchmentThaumcraft;
import com.bewitchment.common.world.gen.ModWorldGen;
import com.bewitchment.proxy.ServerProxy;
import com.bewitchment.registry.ModObjects;
import com.bewitchment.registry.ModRecipes;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="bewitchment", name="Bewitchment", version="0.20.8", acceptedMinecraftVersions="[1.12.2]")
public class Bewitchment {
    public static final String MODID = "bewitchment";
    public static final String NAME = "Bewitchment";
    public static final String VERSION = "0.20.8";
    public static final Logger logger = LogManager.getLogger((String)"Bewitchment");
    @Mod.Instance
    public static Bewitchment instance;
    @SidedProxy(serverSide="com.bewitchment.proxy.ServerProxy", clientSide="com.bewitchment.proxy.ClientProxy")
    public static ServerProxy proxy;
    public static SimpleNetworkWrapper network;
    public static final CreativeTabs tab;
    public static ModConfig config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Remember when I told you how my");
        logger.info("Kin is different in some ways?");
        config = new ModConfig(event.getSuggestedConfigurationFile());
        proxy.registerRendersPreInit();
        ModObjects.preInit();
        CapabilityManager.INSTANCE.register(ExtendedPlayer.class, (Capability.IStorage)new ExtendedPlayer(), ExtendedPlayer::new);
        MinecraftForge.EVENT_BUS.register((Object)new ExtendedPlayerHandler());
        CapabilityManager.INSTANCE.register(MagicPower.class, (Capability.IStorage)new MagicPower(), MagicPower::new);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)new MaterialHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockDropHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MiscHandler());
        if (Loader.isModLoaded((String)"thaumcraft")) {
            MinecraftForge.EVENT_BUS.register((Object)new BewitchmentThaumcraft());
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ModWorldGen(), (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("It's a fact, she is exactly that!");
        logger.info("A harbinger of death from the world of witchcraft,");
        logger.info("And she's feeding them cakes and her ale to this innocent boy,");
        logger.info("And her magic brings dismay!");
        logger.info("I hear her in the wind, the bane of our town");
        logger.info("Come with me, father, I'm to expose a heathen");
        proxy.registerRendersInit();
        ModRecipes.init();
        int id = -1;
        network.registerMessage(SyncExtendedPlayer.Handler.class, SyncExtendedPlayer.class, ++id, Side.CLIENT);
        network.registerMessage(SpawnParticle.Handler.class, SpawnParticle.class, ++id, Side.CLIENT);
        network.registerMessage(SpawnBubble.Handler.class, SpawnBubble.class, ++id, Side.CLIENT);
        network.registerMessage(TeleportPlayerClient.Handler.class, TeleportPlayerClient.class, ++id, Side.CLIENT);
        network.registerMessage(SyncBroom.Handler.class, SyncBroom.class, ++id, Side.CLIENT);
        network.registerMessage(CauldronTeleport.Handler.class, CauldronTeleport.class, ++id, Side.SERVER);
        for (Item item : ForgeRegistries.ITEMS) {
            if (Util.isRelated(true, item, "silver")) {
                MaterialHandler.SILVER_ARMOR.add(item);
            }
            if (Util.isRelated(false, item, "silver")) {
                MaterialHandler.SILVER_TOOLS.add(item);
            }
            if (Util.isRelated(true, item, "cold_iron")) {
                MaterialHandler.COLD_IRON_ARMOR.add(item);
            }
            if (!Util.isRelated(false, item, "cold_iron")) continue;
            MaterialHandler.COLD_IRON_TOOLS.add(item);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModRecipes.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandFortune());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent evt) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_71245_h(true);
    }

    static {
        network = new SimpleNetworkWrapper(MODID);
        tab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack(ModObjects.stone_witches_altar);
            }
        };
    }
}

