/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.capability.extendedplayer;

import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ExtendedPlayerHandler {
    private static final ResourceLocation LOC = new ResourceLocation("bewitchment", "extended_player");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(LOC, (ICapabilityProvider)new ExtendedPlayer());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        ((ExtendedPlayer)event.getEntityPlayer().getCapability(ExtendedPlayer.CAPABILITY, null)).deserializeNBT(((ExtendedPlayer)event.getOriginal().getCapability(ExtendedPlayer.CAPABILITY, null)).serializeNBT());
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            ExtendedPlayer cap = (ExtendedPlayer)event.player.getCapability(ExtendedPlayer.CAPABILITY, null);
            if (cap.fortune != null) {
                if (event.player.field_70170_p.func_82737_E() % 20L == 0L) {
                    --cap.fortuneTime;
                }
                if (cap.fortuneTime == 0) {
                    if (cap.fortune.apply(event.player)) {
                        cap.fortune = null;
                    } else {
                        cap.fortuneTime = event.player.func_70681_au().nextInt(cap.fortune.maxTime - cap.fortune.minTime) + cap.fortune.minTime;
                    }
                    ExtendedPlayer.syncToClient(event.player);
                }
            }
            if (event.player.field_70173_aa % 20 == 0) {
                NBTTagList list = cap.exploredChunks;
                long pos = ChunkPos.func_77272_a((int)event.player.field_70176_ah, (int)event.player.field_70164_aj);
                boolean found = false;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    if (((NBTTagLong)list.func_179238_g(i)).func_150291_c() != pos) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    list.func_74742_a((NBTBase)new NBTTagLong(pos));
                    ExtendedPlayer.syncToClient(event.player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (!event.getEntityLiving().func_184222_aU()) {
                NBTTagList list = ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).uniqueDefeatedBosses;
                String name = EntityRegistry.getEntry(event.getEntityLiving().getClass()).getName();
                boolean found = false;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    if (!list.func_150307_f(i).equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    list.func_74742_a((NBTBase)new NBTTagString(name));
                    ExtendedPlayer.syncToClient(player);
                }
            }
            if (event.getEntityLiving() instanceof EntityMob) {
                ++((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).mobsKilled;
                ExtendedPlayer.syncToClient(player);
            }
        }
    }
}

